/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.explorer;

import java.util.Arrays;
import obp.explorer.ExplorerConfiguration;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.core.BFSExplorer;
import obp.explorer.runtime.core.DFSExplorer;
import obp.explorer.runtime.core.PastFreeZeContextDrivenExplorer;
import org.xid.basics.error.Validator;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.field.CheckboxField;
import org.xid.basics.ui.field.ChoiceField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.TextField;

public class ExplorerConfigurationController
extends Controller<ExplorerConfiguration> {
    private TextField memoryLimitField;
    private ChoiceField<Class<? extends AbstractExplorer>> explorerClassField;
    private CheckboxField checkDBMInclusionField;
    private CompositeField compositeField;

    public CompositeField createFields() {
        this.explorerClassField = new ChoiceField<Class<? extends AbstractExplorer>>("Exploration algorithm", 2){

            public String getText(Class<? extends AbstractExplorer> element) {
                return element.getSimpleName();
            }
        };
        this.checkDBMInclusionField = new CheckboxField("Check DBM Inclusion");
        this.checkDBMInclusionField.setTooltip("This option enables the DBM inclusion check during exploration");
        this.memoryLimitField = new TextField("Memory Limit");
        this.memoryLimitField.setTooltip("Memory limit for exploration, in percentage of total memory or fixed (3000m). Default is 100% (can't be less than 128m).");
        this.memoryLimitField.setValidator((Validator)new Validator.Stub<String>(2, "Invalid memory limit."){

            public boolean isValid(String value) {
                if (value == null) {
                    return true;
                }
                if (ExplorerConfiguration.percentagePattern.matcher(value).matches()) {
                    return true;
                }
                return ExplorerConfiguration.heapOptionPattern.matcher(value).matches();
            }
        });
        this.compositeField = new CompositeField("Explorer", new Field[]{this.explorerClassField, this.checkDBMInclusionField, this.memoryLimitField});
        return this.compositeField;
    }

    public void refreshFields() {
        if (this.getSubject() == null) {
            this.compositeField.setEnable(false);
        } else {
            this.explorerClassField.setRange(Arrays.asList(BFSExplorer.class, DFSExplorer.class, PastFreeZeContextDrivenExplorer.class));
            this.explorerClassField.setValue(((ExplorerConfiguration)this.getSubject()).getExplorerClass());
            this.checkDBMInclusionField.setValue(((ExplorerConfiguration)this.getSubject()).checkDBMInclusion);
            this.memoryLimitField.setValue(((ExplorerConfiguration)this.getSubject()).getMemoryLimit());
            this.compositeField.setEnable(true);
        }
    }

    public boolean updateSubject(Field field) {
        if (field == this.checkDBMInclusionField) {
            ((ExplorerConfiguration)this.getSubject()).checkDBMInclusion = this.checkDBMInclusionField.getValue();
        }
        if (field == this.explorerClassField) {
            ((ExplorerConfiguration)this.getSubject()).setExplorerClass((Class)this.explorerClassField.getValue());
        }
        if (field == this.memoryLimitField) {
            ((ExplorerConfiguration)this.getSubject()).setMemoryLimit(this.memoryLimitField.getValue());
        }
        return false;
    }
}

