/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl.diagram;

import java.util.ArrayList;
import java.util.List;
import obp.cdl.Activity;
import obp.cdl.ActivityReference;
import obp.cdl.AltActivity;
import obp.cdl.EventReference;
import obp.cdl.NullActivity;
import obp.cdl.ParActivity;
import obp.cdl.SeqActivity;
import obp.ui.cdl.diagram.ActivityReferenceElement;
import obp.ui.cdl.diagram.AltActivityElement;
import obp.ui.cdl.diagram.CDLDiagram;
import obp.ui.cdl.diagram.EventReferenceElement;
import obp.ui.cdl.diagram.FoldedActivityElement;
import obp.ui.cdl.diagram.NullActivityElement;
import obp.ui.cdl.diagram.ParActivityElement;
import obp.ui.cdl.diagram.SeqActivityElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.Element;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;
import org.xid.basics.ui.diagram.interaction.InteractionObject;

public abstract class ActivityElement
extends Element.Stub {
    public static final int FOLD = 100;
    public static final int UNFOLD = 101;
    protected float[] northPoint;
    protected float[] size;
    protected final boolean rejoin;
    protected final List<ActivityElement> children = new ArrayList<ActivityElement>();

    public ActivityElement(boolean rejoin, float[] northPoint) {
        this.northPoint = northPoint;
        this.rejoin = rejoin;
        this.size = new float[2];
    }

    public abstract Activity getModel();

    public abstract void buildChildren(CDLDiagram var1);

    public float[] getPoint() {
        return this.northPoint;
    }

    public float[] getSize() {
        return this.size;
    }

    public float[] getRectangle() {
        return Geometry.rectangleAlignedOn((float)this.size[0], (float)this.size[1], (float)this.northPoint[0], (float)this.northPoint[1], (int)6);
    }

    public float[] getNorthPoint() {
        return this.northPoint;
    }

    public float[] getSouthPoint() {
        return new float[]{this.northPoint[0], this.northPoint[1] + this.size[1]};
    }

    public void moveNorthPoint(float dx, float dy) {
        this.northPoint[0] = this.northPoint[0] + dx;
        this.northPoint[1] = this.northPoint[1] + dy;
    }

    public void computeBounds(float[] result, DiagramContext context) {
        Geometry.copyPoints((float[])this.getRectangle(), (float[])result);
        Geometry.expandRectangle((float[])result, (float)10.0f, (float)20.0f);
    }

    public void display(GC gc, DiagramContext context) {
    }

    private void displayNbOccurences(GC gc, DiagramContext context, int nbOccurrences) {
        String occurrences = Integer.toString(nbOccurrences);
        float height = Math.max(16.0f, (float)gc.getFontMetrics().getHeight());
        float width = 16.0f;
        for (char c : occurrences.toCharArray()) {
            width += (float)(gc.getCharWidth(c) + gc.getAdvanceWidth(c));
        }
        float[] tmpPoint = Geometry.getRectanglePoint((float[])this.getRectangle(), (int)1);
        Geometry.translatePointsBy((float[])tmpPoint, (float)-10.0f, (float)-10.0f);
        float[] tmpRectangle = Geometry.rectangleAlignedOn((float)width, (float)height, (float)tmpPoint[0], (float)tmpPoint[1], (int)1);
        Geometry.expandRectangle((float[])tmpRectangle, (float)5.0f, (float)5.0f);
        gc.setLineWidth(0);
        gc.setBackground(context.getResources().getColor(new RGB(230, 230, 255)));
        GcUtils.drawRoundRectangle((GC)gc, (float[])tmpRectangle, (float)20.0f, (float)20.0f, (boolean)true);
        gc.setLineWidth(1);
        GcUtils.drawImageAligned((GC)gc, (Image)context.getResources().getImage("refresh.gif"), (float)tmpPoint[0], (float)tmpPoint[1], (int)1);
        tmpPoint[0] = tmpPoint[0] - 20.0f;
        GcUtils.drawStringAligned((GC)gc, (String)occurrences, (float)tmpPoint[0], (float)tmpPoint[1], (int)1);
    }

    protected void displayFrame(GC gc, DiagramContext context, String name, int occurences) {
        if (occurences > 1) {
            this.displayNbOccurences(gc, context, occurences);
        }
        float[] rectangle = this.getRectangle();
        gc.setForeground(context.getResources().getColor(new RGB(150, 100, 100)));
        if (name != null) {
            float[] upperLeftPoint = Geometry.getRectanglePoint((float[])rectangle, (int)5);
            GcUtils.drawStringAligned((GC)gc, (String)name, (float)upperLeftPoint[0], (float)upperLeftPoint[1], (int)5);
        }
        gc.setLineStyle(3);
        gc.setLineWidth(0);
        Geometry.expandRectangle((float[])rectangle, (float)5.0f, (float)5.0f);
        GcUtils.drawRoundRectangle((GC)gc, (float[])rectangle, (float)10.0f, (float)10.0f, (boolean)false);
    }

    public void hitTesting(List<Element> result, float[] detectionPoint, float[] detectionRectangle, int type, DiagramContext context) {
        for (ActivityElement child : this.children) {
            child.hitTesting(result, detectionPoint, detectionRectangle, type, context);
            if (result.isEmpty() || detectionRectangle != null) continue;
            return;
        }
        if (detectionRectangle == null) {
            if (Geometry.rectangleContainsPoint((float[])this.getRectangle(), (float[])detectionPoint)) {
                result.add((Element)this);
            }
        } else if (Geometry.rectangleIntersectsRectangle((float[])this.getRectangle(), (float[])detectionRectangle)) {
            result.add((Element)this);
        }
    }

    public boolean click(InteractionObject interaction, float[] point, int count, DiagramContext context) {
        if (interaction != null) {
            switch (interaction.getType()) {
                case 100: {
                    this.setUnfolded(context.getDiagram(), false);
                    break;
                }
                case 101: {
                    this.setUnfolded(context.getDiagram(), true);
                }
            }
            context.getDiagram().invalidateBounds();
        }
        return false;
    }

    protected void setUnfolded(Diagram<?> diagram, boolean folded) {
        if (diagram instanceof CDLDiagram) {
            ((CDLDiagram)diagram).setUnfolded(this.getModel(), folded);
        }
    }

    public static ActivityElement createElement(CDLDiagram diagram, Activity activity, boolean rejoin, float[] northWestPoint) {
        int occurrences = activity.getLoop();
        float[] newPoint = Geometry.copyPoints((float[])northWestPoint);
        ActivityElement element = null;
        if (activity instanceof SeqActivity) {
            element = new SeqActivityElement((SeqActivity)activity, occurrences, rejoin, newPoint);
        } else if (activity instanceof AltActivity) {
            element = new AltActivityElement((AltActivity)activity, occurrences, rejoin, newPoint);
        } else if (activity instanceof ParActivity) {
            element = new ParActivityElement((ParActivity)activity, rejoin, newPoint);
        } else if (activity instanceof EventReference) {
            element = new EventReferenceElement((EventReference)activity, occurrences, newPoint);
        } else if (activity instanceof NullActivity) {
            element = new NullActivityElement((NullActivity)activity, occurrences, newPoint);
        } else if (activity instanceof ActivityReference) {
            element = diagram.isUnfolded(activity) ? new ActivityReferenceElement((ActivityReference)activity, rejoin, newPoint) : new FoldedActivityElement((ActivityReference)activity, occurrences, rejoin, newPoint);
        } else {
            System.out.println("Can't create Element for " + activity);
        }
        if (element != null) {
            ((ActivityElement)element).buildChildren(diagram);
        }
        return element;
    }
}

