/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Variable;
import obp.fiacre.util.StatementUtil;

public class ProcessUtil {
    public static Set<Variable> getUsedVariables(ProcessDecl process) {
        HashSet<Variable> referenced = new HashSet<Variable>();
        referenced.addAll(StatementUtil.findUsedVariables(process.getInitAction()));
        for (Transition transition : process.getTransitionList()) {
            referenced.addAll(StatementUtil.findUsedVariables(transition.getAction()));
        }
        return referenced;
    }

    public static Set<Variable> getModifiedVariables(ProcessDecl process) {
        HashSet<Variable> referenced = new HashSet<Variable>();
        for (Transition transition : process.getTransitionList()) {
            referenced.addAll(StatementUtil.findModifiedVariables(transition.getAction()));
        }
        return referenced;
    }

    public static <T extends Statement> List<T> findAll(Class<T> type, ProcessDecl process) {
        ArrayList<T> result = new ArrayList<T>();
        for (Transition transition : process.getTransitionList()) {
            result.addAll(StatementUtil.findAll(type, transition.getAction()));
        }
        return result;
    }
}

