/*
 * Decompiled with CFR 0.152.
 */
package obp.cc2dot;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import obp.cc.ConcreteContext;
import obp.transfo.cc.ConcreteContextExport;
import obp.util.ConcreteContextUtil;

public class ConcreteContextToDot {
    File concreteContextPath = null;
    File dotDirectory = null;
    boolean simpleDot = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File cc2dot(ConcreteContext cc, File dotDirectory, boolean isSimple) throws IOException {
        File file = dotDirectory == null ? new File("./" + cc.getName() + ".dot") : new File(dotDirectory, cc.getName() + ".dot");
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            bw.write(isSimple ? ConcreteContextExport.toSimpleDot(cc) : ConcreteContextExport.toDot(cc));
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
        return file;
    }

    private void usage() {
        System.out.println("Usage: ConcreteContextToDot [options] concrete-context-path");
        System.out.println("Mandatory parameters: ");
        System.out.println("\t[--dot-directory or -o] path\tdestination Path for generated dot.");
        System.out.println();
        System.out.println("Optional parameters: ");
        System.out.println("\t[--actions or -a] \t represent actions in dot.");
        System.out.println();
        System.out.println("Other parameters:");
        System.out.println("\t[--help or -h]\t\t\tPrints this help and exit.");
    }

    public boolean readArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("--dot-directory".equals(args[i]) || "-o".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--dot-directory' needs an argument.");
                    return false;
                }
                if (args[i].length() == 0 || args[i].startsWith("-")) {
                    System.err.println("Invalid file name '" + args[i] + "'.");
                    return false;
                }
                this.dotDirectory = new File(args[i]);
                continue;
            }
            if ("--actions".equals(args[i]) || "-a".equals(args[i])) {
                this.simpleDot = false;
                continue;
            }
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                this.usage();
                return false;
            }
            if (this.concreteContextPath != null) continue;
            this.concreteContextPath = new File(args[i]);
        }
        if (this.concreteContextPath == null) {
            System.err.println("missing path to the concrete context file");
            this.usage();
            return false;
        }
        if (this.dotDirectory == null) {
            System.err.println("Missing dot directory path (--context-directory)");
            this.usage();
            return false;
        }
        return true;
    }

    public void defaultSplit() {
        if (!this.dotDirectory.exists()) {
            this.dotDirectory.mkdirs();
        }
        try {
            ConcreteContext cc = ConcreteContextUtil.loadCC(this.concreteContextPath);
            File dotFile = this.cc2dot(cc, this.dotDirectory, this.simpleDot);
            System.out.println("Context " + cc.getName() + " exporte to dot in :");
            System.out.println("\t- " + dotFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ConcreteContextToDot main = new ConcreteContextToDot();
        try {
            if (main.readArguments(args)) {
                main.defaultSplit();
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

