/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import spinja.model.Model;
import spinja.model.Transition;
import spinja.search.Simulation;
import spinja.search.TransitionCalculator;

public class UserSimulation<M extends Model<T>, T extends Transition>
extends Simulation<M, T> {
    private final BufferedReader reader;
    private final List<T> enabled = new ArrayList<T>(64);

    public UserSimulation(M m, TransitionCalculator<M, T> transitionCalculator) {
        super(m, transitionCalculator);
        this.reader = new BufferedReader(new InputStreamReader(System.in));
    }

    @Override
    public T nextTransition() {
        Object e = null;
        this.enabled.clear();
        while ((e = this.nextTransition.next(this.model, e)) != null) {
            this.enabled.add(e);
        }
        if (this.enabled.size() == 0) {
            System.out.println("Deadlock");
            return null;
        }
        int n = -999;
        while (n < 0 || n > this.enabled.size()) {
            if (n != -999) {
                System.out.println("Please give a number between 1 and " + this.enabled.size() + " or 0 to stop.");
            }
            for (int i = 0; i < this.enabled.size(); ++i) {
                System.out.println("" + (i + 1) + ") " + ((Transition)this.enabled.get(i)).toString());
            }
            System.out.print("Which transition? ");
            try {
                n = Integer.parseInt(this.reader.readLine());
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            catch (IOException iOException) {
                System.out.println("IO Error: " + iOException.getMessage());
                n = 0;
            }
        }
        if (n == 0) {
            return null;
        }
        return (T)((Transition)this.enabled.get(n - 1));
    }
}

