/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler;

import java.util.ArrayList;
import java.util.List;
import spinja.promela.compiler.Specification;
import spinja.promela.compiler.automaton.Automaton;
import spinja.promela.compiler.automaton.State;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.expression.Identifier;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.variable.Variable;
import spinja.promela.compiler.variable.VariableContainer;
import spinja.promela.compiler.variable.VariableStore;
import spinja.util.StringWriter;

public class Proctype
implements VariableContainer {
    private final Specification specification;
    private final int id;
    private final int nrActive;
    private int priority;
    private final String name;
    private final Automaton automaton;
    private final VariableStore varStore;
    private Expression enabler;
    private boolean isArgument;
    private final List<Variable> arguments;
    private final List<Variable> channelXR = new ArrayList<Variable>();
    private final List<Variable> channelXS = new ArrayList<Variable>();

    public Proctype(Specification specification, int n, int n2, String string) {
        this.specification = specification;
        this.id = n;
        this.nrActive = n2;
        this.name = string;
        this.automaton = new Automaton(this);
        this.varStore = new VariableStore();
        this.priority = 0;
        this.enabler = null;
        this.isArgument = true;
        this.arguments = new ArrayList<Variable>();
    }

    @Override
    public void addVariable(Variable variable) {
        this.varStore.addVariable(variable);
        if (this.isArgument) {
            this.arguments.add(variable);
        }
    }

    public void addXR(Identifier identifier) {
        this.channelXR.add(identifier.getVariable());
    }

    public void addXS(Identifier identifier) {
        this.channelXS.add(identifier.getVariable());
    }

    public void generateCode(StringWriter stringWriter) throws ParseException {
        stringWriter.appendLine("public class ", this.getName(), " extends PromelaProcess {");
        stringWriter.indent();
        this.generateLocalVars(stringWriter);
        this.generateConstructor(stringWriter);
        this.generateStorable(stringWriter);
        this.generateToString(stringWriter);
        if (this.enabler != null) {
            // empty if block
        }
        stringWriter.outdent();
        stringWriter.appendLine("}");
    }

    protected void generateConstructor(StringWriter stringWriter) throws ParseException {
        stringWriter.appendLine("public ", this.getName(), "(boolean decoding) {").indent();
        if (this.specification.getNever() == this) {
            stringWriter.appendLine("super(", this.getSpecification().getName(), "Model.this, new State[", this.automaton.size(), "], ", this.automaton.getStartState().getStateId(), ", 0);");
        } else {
            stringWriter.appendLine("super(", this.getSpecification().getName(), "Model.this, new State[", this.automaton.size(), "], ", this.automaton.getStartState().getStateId(), ");");
        }
        stringWriter.appendLine(new Object[0]);
        this.automaton.generateTable(stringWriter);
        stringWriter.outdent().appendLine("}").appendLine(new Object[0]);
        stringWriter.appendLine("public ", this.getName(), "(", this.getArgs(), ") throws ValidationException {").indent();
        stringWriter.appendLine("this(false);");
        stringWriter.appendLine(new Object[0]);
        for (Variable variable : this.varStore.getVariables()) {
            if (this.arguments.contains(variable)) continue;
            variable.printInitExpr(stringWriter);
        }
        if (!this.arguments.isEmpty()) {
            stringWriter.appendLine(new Object[0]);
            for (Variable variable : this.arguments) {
                stringWriter.appendLine("this.", variable.getName(), " = param_", variable.getName(), ";");
            }
        }
        stringWriter.outdent().appendLine("}").appendLine(new Object[0]);
    }

    protected void generateLocalVars(StringWriter stringWriter) {
        for (Variable variable : this.varStore.getVariables()) {
            stringWriter.appendLine("protected ", variable.getType().getJavaName(), variable.getArraySize() > 1 ? "[]" : "", " ", variable.getName(), ";");
        }
        stringWriter.appendLine(new Object[0]);
    }

    protected void generateStorable(StringWriter stringWriter) {
        stringWriter.appendLine("public int getSize() {");
        stringWriter.appendLine("  return " + (this.varStore.getBufferSize() + 2) + ";");
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("public void encode(DataWriter _writer) {");
        stringWriter.indent();
        stringWriter.appendLine("_writer.writeByte(0x", Integer.toHexString(this.id), ");");
        stringWriter.appendLine("_writer.writeByte(_sid);");
        this.varStore.printEncode(stringWriter);
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("public boolean decode(DataReader _reader) {");
        stringWriter.indent();
        stringWriter.appendLine("if(_reader.readByte() != 0x", Integer.toHexString(this.id), ") return false;");
        stringWriter.appendLine("_sid = _reader.readByte();");
        this.varStore.printDecode(stringWriter);
        stringWriter.appendLine("return true;");
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
    }

    protected void generateToString(StringWriter stringWriter) {
        stringWriter.appendLine("public String toString() {");
        stringWriter.indent();
        stringWriter.appendLine("StringBuilder sb = new StringBuilder();");
        stringWriter.appendLine("if(_exclusive == _pid) sb.append(\"<atomic>\");");
        stringWriter.appendLine("sb.append(\"" + this.getName() + " (\" + _pid + \",\" + _sid + \"): \");");
        this.varStore.printToString(stringWriter);
        stringWriter.appendLine("return sb.toString();");
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine(new Object[0]);
    }

    protected String getArgs() {
        StringWriter stringWriter = new StringWriter();
        for (Variable variable : this.arguments) {
            stringWriter.append(variable == this.arguments.get(0) ? "" : ", ").append(variable.getType().getJavaName()).append(" param_").append(variable.getName());
        }
        return stringWriter.toString();
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public final String getName() {
        return this.name;
    }

    public int getNrActive() {
        return this.nrActive;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public State getStartState() {
        return this.automaton.getStartState();
    }

    @Override
    public Variable getVariable(String string) {
        return this.varStore.getVariable(string);
    }

    @Override
    public List<Variable> getVariables() {
        return this.varStore.getVariables();
    }

    @Override
    public boolean hasVariable(String string) {
        return string.equals("_pid") || this.varStore.hasVariable(string);
    }

    public boolean isXR(Variable variable) {
        return this.channelXR.contains(variable);
    }

    public boolean isXS(Variable variable) {
        return this.channelXS.contains(variable);
    }

    public void lastArgument() {
        this.isArgument = false;
    }

    public void setEnabler(Expression expression) {
        this.enabler = expression;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public String toString() {
        return this.getName();
    }
}

