/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;

public interface NotificationSupport {
    public boolean addListener(NotificationListener var1);

    public boolean removeListener(NotificationListener var1);

    public static class Stub
    implements NotificationSupport {
        private final Object source;
        private List<NotificationListener> listeners;

        public Stub(Object source) {
            this.source = source;
        }

        public List<NotificationListener> getListeners() {
            if (this.listeners == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.listeners);
        }

        @Override
        public boolean addListener(NotificationListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<NotificationListener>();
            }
            return this.listeners.add(listener);
        }

        @Override
        public boolean removeListener(NotificationListener listener) {
            if (this.listeners == null) {
                return false;
            }
            boolean removed = this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
            return removed;
        }

        public void fireNotification(Notification notification) {
            if (this.listeners != null) {
                for (NotificationListener listener : this.listeners) {
                    listener.notified(notification);
                }
            }
        }

        public void fireNotification(int type, String name) {
            this.fireNotification(new Notification(this.source, type, name));
        }

        public void fireValueNotification(int type, String name, Object newValue, Object oldValue) {
            this.fireNotification(new Notification(this.source, type, name, newValue, oldValue));
        }

        public void fireIndexedValueNotification(int type, String name, Object newValue, Object oldValue, int index) {
            this.fireNotification(new Notification(this.source, type, name, newValue, oldValue, index));
        }
    }
}

