/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.management;

import java.io.IOException;
import javax.management.NotCompliantMBeanException;
import tlc2.TLC;
import tlc2.TLCGlobals;
import tlc2.tool.ModelChecker;
import tlc2.tool.TLCState;
import tlc2.tool.distributed.management.TLCStatisticsMXBean;
import tlc2.tool.fp.DiskFPSet;
import tlc2.tool.management.TLCStandardMBean;

public class ModelCheckerMXWrapper
extends TLCStandardMBean
implements TLCStatisticsMXBean {
    private final ModelChecker modelChecker;
    private final TLC tlc;

    public ModelCheckerMXWrapper(ModelChecker aModelChecker, TLC tlc) throws NotCompliantMBeanException {
        super((Class)TLCStatisticsMXBean.class);
        this.modelChecker = aModelChecker;
        this.tlc = tlc;
        this.registerMBean("tlc2.tool:type=ModelChecker");
    }

    @Override
    public long getStatesGenerated() {
        return this.modelChecker.getStatesGenerated();
    }

    @Override
    public long getDistinctStatesGenerated() {
        if (this.modelChecker.theFPSet instanceof DiskFPSet) {
            DiskFPSet diskFPSet = (DiskFPSet)this.modelChecker.theFPSet;
            return diskFPSet.getFileCnt() + diskFPSet.getTblCnt();
        }
        return this.modelChecker.theFPSet.size();
    }

    @Override
    public long getStateQueueSize() {
        return this.modelChecker.theStateQueue.size();
    }

    @Override
    public long getStatesGeneratedPerMinute() {
        return this.modelChecker.statesPerMinute;
    }

    @Override
    public long getDistinctStatesGeneratedPerMinute() {
        return this.modelChecker.distinctStatesPerMinute;
    }

    @Override
    public int getProgress() {
        try {
            return this.modelChecker.trace.getLevelForReporting();
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public int getWorkerCount() {
        return TLCGlobals.getNumWorkers();
    }

    @Override
    public void checkpoint() {
        TLCGlobals.forceChkpt();
    }

    @Override
    public long getAverageBlockCnt() {
        return 1L;
    }

    @Override
    public double getRuntimeRatio() {
        return this.modelChecker.getRuntimeRatio();
    }

    @Override
    public void liveCheck() {
        this.modelChecker.forceLiveCheck();
    }

    @Override
    public String getCurrentState() {
        TLCState state = this.modelChecker.theStateQueue.sPeek();
        if (state != null) {
            return state.toString();
        }
        return "N/A";
    }

    @Override
    public String getSpecName() {
        return this.tlc.getSpecName();
    }

    @Override
    public String getModelName() {
        return this.tlc.getModelName();
    }
}

