/*
 * Decompiled with CFR 0.152.
 */
package obp.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.EventReference;
import obp.property.OccurrenceExpression;
import obp.property.Property;
import obp.property.PropertyVisitor;
import obp.property.TempGuard;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class PropertyExistence
extends Property
implements BoostObject {
    private final List<EventReference> eventList = new ArrayList<EventReference>();
    private OccurrenceExpression occurrenceExpression;
    private TempGuard tempGuard;
    private boolean repeatability;

    public PropertyExistence() {
    }

    protected PropertyExistence(Boost boost) {
        super(boost);
        for (EventReference oneChild : BoostUtil.readObjectList((Boost)boost, EventReference.class)) {
            this.eventList.add(oneChild);
        }
        this.occurrenceExpression = (OccurrenceExpression)boost.readObject(OccurrenceExpression.class);
        this.tempGuard = (TempGuard)boost.readObject(TempGuard.class);
        this.repeatability = boost.readBoolean();
    }

    public List<EventReference> getEventList() {
        return Collections.unmodifiableList(this.eventList);
    }

    public int getEventCount() {
        return this.eventList.size();
    }

    public EventReference getEvent(int index) {
        if (index < 0 || index >= this.getEventCount()) {
            return null;
        }
        return this.eventList.get(index);
    }

    public void addEvent(EventReference newValue) {
        this.addEvent(this.getEventCount(), newValue);
    }

    public void addEvent(int index, EventReference newValue) {
        this.eventList.add(index, newValue);
    }

    public EventReference setEvent(int index, EventReference newValue) {
        return this.eventList.set(index, newValue);
    }

    public void addAllEvent(Collection<EventReference> toAddList) {
        for (EventReference newValue : toAddList) {
            this.addEvent(this.getEventCount(), newValue);
        }
    }

    public void removeEvent(EventReference value) {
        int index = this.eventList.indexOf(value);
        if (index >= 0) {
            this.removeEvent(index);
        }
    }

    public void removeEvent(int index) {
        this.eventList.remove(index);
    }

    public OccurrenceExpression getOccurrenceExpression() {
        return this.occurrenceExpression;
    }

    public void setOccurrenceExpression(OccurrenceExpression newValue) {
        if (this.occurrenceExpression == null ? newValue != null : !this.occurrenceExpression.equals(newValue)) {
            this.occurrenceExpression = newValue;
        }
    }

    public TempGuard getTempGuard() {
        return this.tempGuard;
    }

    public void setTempGuard(TempGuard newValue) {
        if (this.tempGuard == null ? newValue != null : !this.tempGuard.equals(newValue)) {
            this.tempGuard = newValue;
        }
    }

    public boolean isRepeatability() {
        return this.repeatability;
    }

    public void setRepeatability(boolean newValue) {
        if (this.repeatability != newValue) {
            this.repeatability = newValue;
        }
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.eventList);
        boost.writeObject((BoostObject)this.occurrenceExpression);
        boost.writeObject((BoostObject)this.tempGuard);
        boost.writeBoolean(this.repeatability);
    }

    @Override
    public void accept(PropertyVisitor visitor) {
        visitor.visitPropertyExistence(this);
    }
}

