/*
 * Decompiled with CFR 0.152.
 */
package obp.obs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.EventReference;
import obp.obs.ObsVisitor;
import obp.obs.Reset;
import obp.obs.State;
import obp.obs.When;
import obp.predicate.Predicate;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class Transition
implements BoostObject {
    private State source;
    private When when;
    private Predicate guard;
    private final List<EventReference> eventsList = new ArrayList<EventReference>();
    private Reset reset;
    private State target;

    public Transition() {
    }

    protected Transition(Boost boost) {
        boost.register((BoostObject)this);
        this.source = (State)boost.readObject(State.class);
        this.when = (When)boost.readObject(When.class);
        this.guard = (Predicate)boost.readObject(Predicate.class);
        for (EventReference oneChild : BoostUtil.readObjectList((Boost)boost, EventReference.class)) {
            this.eventsList.add(oneChild);
        }
        this.reset = (Reset)boost.readObject(Reset.class);
        this.target = (State)boost.readObject(State.class);
    }

    public State getSource() {
        return this.source;
    }

    public void setSource(State newValue) {
        if (this.source == null ? newValue != null : !this.source.equals(newValue)) {
            this.source = newValue;
        }
    }

    public void setSourceAndOpposite(State newValue) {
        if (this.source != null) {
            this.source.removeOutTransition(this);
        }
        if (newValue != null) {
            newValue.addOutTransition(this);
        }
        this.setSource(newValue);
    }

    public When getWhen() {
        return this.when;
    }

    public void setWhen(When newValue) {
        if (this.when == null ? newValue != null : !this.when.equals(newValue)) {
            this.when = newValue;
        }
    }

    public Predicate getGuard() {
        return this.guard;
    }

    public void setGuard(Predicate newValue) {
        if (this.guard == null ? newValue != null : !this.guard.equals(newValue)) {
            this.guard = newValue;
        }
    }

    public List<EventReference> getEventsList() {
        return Collections.unmodifiableList(this.eventsList);
    }

    public int getEventsCount() {
        return this.eventsList.size();
    }

    public EventReference getEvents(int index) {
        if (index < 0 || index >= this.getEventsCount()) {
            return null;
        }
        return this.eventsList.get(index);
    }

    public void addEvents(EventReference newValue) {
        this.addEvents(this.getEventsCount(), newValue);
    }

    public void addEvents(int index, EventReference newValue) {
        this.eventsList.add(index, newValue);
    }

    public EventReference setEvents(int index, EventReference newValue) {
        return this.eventsList.set(index, newValue);
    }

    public void addAllEvents(Collection<EventReference> toAddList) {
        for (EventReference newValue : toAddList) {
            this.addEvents(this.getEventsCount(), newValue);
        }
    }

    public void removeEvents(EventReference value) {
        int index = this.eventsList.indexOf(value);
        if (index >= 0) {
            this.removeEvents(index);
        }
    }

    public void removeEvents(int index) {
        this.eventsList.remove(index);
    }

    public Reset getReset() {
        return this.reset;
    }

    public void setReset(Reset newValue) {
        if (this.reset == null ? newValue != null : !this.reset.equals(newValue)) {
            this.reset = newValue;
        }
    }

    public State getTarget() {
        return this.target;
    }

    public void setTarget(State newValue) {
        if (this.target == null ? newValue != null : !this.target.equals(newValue)) {
            this.target = newValue;
        }
    }

    public void setTargetAndOpposite(State newValue) {
        if (this.target != null) {
            this.target.removeInTransition(this);
        }
        if (newValue != null) {
            newValue.addInTransition(this);
        }
        this.setTarget(newValue);
    }

    public void writeToBoost(Boost boost) {
        boost.writeObject((BoostObject)this.source);
        boost.writeObject((BoostObject)this.when);
        boost.writeObject((BoostObject)this.guard);
        BoostUtil.writeObjectCollection((Boost)boost, this.eventsList);
        boost.writeObject((BoostObject)this.reset);
        boost.writeObject((BoostObject)this.target);
    }

    public void accept(ObsVisitor visitor) {
        visitor.visitTransition(this);
    }
}

