/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.util.List;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.core.ITransitionExecutor;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.obs.SynchronousCommunicationAction;

public abstract class Channel {
    public final short id;
    public final String name;
    public final short clockId;
    public final short minBoundInternal;
    public final short maxBoundInternal;
    private short sourceId = (short)-1;
    private Object[] values;

    public Channel(String name, SymbolsTable symbols) {
        this.name = name;
        this.id = symbols.newChannelId(name);
        this.clockId = (short)-1;
        this.minBoundInternal = 0;
        this.maxBoundInternal = 0;
    }

    public Channel(String name, SymbolsTable symbols, int minBound, boolean minBoundStrict, int maxBound, boolean maxBoundStrict) {
        this.name = name;
        this.id = symbols.newChannelId(name);
        this.clockId = symbols.newClockIndexWith(minBound, minBoundStrict, maxBound, maxBoundStrict);
        this.minBoundInternal = DBM.computeInternal(-minBound, minBoundStrict);
        this.maxBoundInternal = DBM.computeInternal(maxBound, maxBoundStrict);
    }

    public Channel(String name, SymbolsTable symbols, int minBound, boolean minBoundStrict) {
        this.name = name;
        this.id = symbols.newChannelId(name);
        this.clockId = symbols.newClockIndex();
        this.minBoundInternal = DBM.computeInternal(-minBound, minBoundStrict);
        this.maxBoundInternal = DBM.computeInternalInfinite();
    }

    public Channel(String name, SymbolsTable symbols, short clockId, int minBound, boolean minBoundStrict, int maxBound, boolean maxBoundStrict) {
        this.name = name;
        this.id = symbols.newChannelId(name);
        this.clockId = clockId;
        this.minBoundInternal = DBM.computeInternal(-minBound, minBoundStrict);
        this.maxBoundInternal = DBM.computeInternal(maxBound, maxBoundStrict);
    }

    public Channel(String name, SymbolsTable symbols, short clockId, int minBound, boolean minBoundStrict) {
        this.name = name;
        this.id = symbols.newChannelId(name);
        this.clockId = clockId;
        this.minBoundInternal = DBM.computeInternal(-minBound, minBoundStrict);
        this.maxBoundInternal = DBM.computeInternalInfinite();
    }

    protected abstract boolean isActive(Transition[] var1, int var2, Transition[] var3, int var4);

    protected abstract void computeSynchronizations(Configuration var1, Transition[] var2, int var3, Transition[] var4, int var5, ITransitionExecutor var6);

    public void output(short behaviorId, List<AtomicAction> actions2, Object ... values) {
        this.sourceId = behaviorId;
        this.values = values;
    }

    public void input(short behaviorId, List<AtomicAction> actions2) {
        actions2.add(new SynchronousCommunicationAction(this.sourceId, behaviorId, this.id, this.values));
    }

    public <T> T value(Class<T> type, int index) {
        return (T)this.values[index];
    }

    public void reset() {
        this.sourceId = (short)-1;
        this.values = null;
    }
}

