/*
 * Decompiled with CFR 0.152.
 */
package com.jpro.webapi;

import com.jpro.webapi.InstanceCloseListener;
import com.jpro.webapi.ScriptResultListener;
import com.jpro.webapi.WebAPIConsumer;
import com.jpro.webapi.WebCallback;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;

public abstract class WebAPI {
    private static Class<?> webAPIImplClass = null;

    public static boolean isBrowser() {
        return webAPIImplClass != null;
    }

    public static WebAPI getWebAPI(Window window) throws RuntimeException {
        if (!WebAPI.isBrowser()) {
            throw new RuntimeException("createWebAPI is not implemented on this Platform!");
        }
        try {
            Method method = webAPIImplClass.getMethod("getWebAPI", Window.class);
            return (WebAPI)method.invoke(null, window);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException("Unable to create the WebAPI!", reflectiveOperationException);
        }
    }

    public static WebAPI getWebAPI(Scene scene) throws RuntimeException {
        if (scene.getWindow() == null) {
            throw new RuntimeException("getWebAPI: The window of the provided scene is null!");
        }
        return WebAPI.getWebAPI(scene.getWindow());
    }

    public static void getWebAPI(Node node, WebAPIConsumer webAPIConsumer) {
        ChangeListener[] changeListenerArray;
        changeListenerArray = new ChangeListener[]{(observableValue, scene, scene2) -> {
            if (scene2 != null) {
                node.sceneProperty().removeListener(changeListenerArray[0]);
                webAPIConsumer.consume(WebAPI.getWebAPI(scene2));
            }
        }};
        node.sceneProperty().addListener(changeListenerArray[0]);
    }

    public static void setWebAPIImpl(Class<?> clazz) {
        webAPIImplClass = clazz;
    }

    public abstract String getServerName();

    public abstract Map<String, String> getCookies();

    public abstract boolean isMobile();

    public abstract String getLanguage();

    public abstract List<String> getLanguages();

    public Map<String, String> getURLQueryParams() {
        String string = this.getServerName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URI uRI = URI.create(string);
        if (uRI.getQuery() == null) {
            return hashMap;
        }
        for (String string2 : uRI.getQuery().split("&")) {
            if (string2 == null) continue;
            String[] stringArray = string2.split("=");
            if (stringArray.length > 1) {
                hashMap.put(stringArray[0], stringArray[1]);
                continue;
            }
            hashMap.put(stringArray[0], "");
        }
        return hashMap;
    }

    public abstract Rectangle2D getBrowserSize();

    public abstract int getInstanceID();

    public abstract String getServer();

    public abstract void addInstanceCloseListener(InstanceCloseListener var1);

    public abstract void removeInstanceCloseListener(InstanceCloseListener var1);

    public abstract void loadJSFile(URL var1);

    public abstract void executeScript(String var1);

    public abstract String executeScriptWithReturn(String var1) throws Exception;

    public abstract void executeScriptWithListener(String var1, ScriptResultListener var2);

    public abstract String createPublicFile(URL var1);

    public abstract void downloadURL(URL var1);

    public abstract void downloadResource(String var1);

    public abstract void openLocalURL(URL var1);

    public abstract void openLocalResource(String var1);

    public abstract void registerValue(String var1, Node var2);

    public abstract void registerValue(String var1, String var2);

    public abstract void registerJavaFunction(String var1, WebCallback var2);

    public abstract void requestLayout(Scene var1);

    public abstract void openStageAsPopup(Stage var1);

    public abstract void openStageAsTab(Stage var1);

    public void runAfterUpdate(Runnable runnable) {
    }

    public abstract FileUploader makeFileUploadNode(Node var1);

    public static abstract class FileUploader {
        public abstract ReadOnlyObjectProperty<File> uploadedFileProperty();

        public abstract ReadOnlyStringProperty selectedFileProperty();

        public abstract ReadOnlyIntegerProperty selectedFileSizeProperty();

        public abstract BooleanProperty selectFileOnDropProperty();

        public abstract BooleanProperty selectFileOnClickProperty();

        public abstract ReadOnlyDoubleProperty progressProperty();

        public abstract ReadOnlyBooleanProperty fileDragOverProperty();

        public abstract void uploadFile();

        public abstract ObjectProperty<FileSelectedListener> onFileSelectedProperty();

        public File getUploadedFile() {
            return (File)this.uploadedFileProperty().getValue();
        }

        public String getSelectedFile() {
            return this.selectedFileProperty().getValue();
        }

        public int getSelectedFileSize() {
            return this.selectedFileSizeProperty().getValue();
        }

        public void setSelectFileOnClick(Boolean bl) {
            this.selectFileOnClickProperty().setValue(bl);
        }

        public boolean getSelectFileOnClick() {
            return this.selectFileOnClickProperty().getValue();
        }

        public void setSelectFileOnDrop(Boolean bl) {
            this.selectFileOnDropProperty().setValue(bl);
        }

        public boolean getSelectFileOnDrop() {
            return this.selectFileOnDropProperty().getValue();
        }

        public double getProgress() {
            return this.progressProperty().getValue();
        }

        public boolean getFileDragOver() {
            return this.fileDragOverProperty().getValue();
        }

        public FileSelectedListener getOnFileSelected() {
            return (FileSelectedListener)this.onFileSelectedProperty().getValue();
        }

        public void setOnFileSelected(FileSelectedListener fileSelectedListener) {
            this.onFileSelectedProperty().setValue((Object)fileSelectedListener);
        }
    }

    @FunctionalInterface
    public static interface FileSelectedListener {
        public void handle(String var1);
    }
}

