/*
 * Decompiled with CFR 0.152.
 */
package language.compositionLang.parser;

import java.util.HashMap;
import java.util.Map;
import language.compositionLang.grammar.CompositionLangBaseListener;
import language.compositionLang.grammar.CompositionLangParser;
import language.compositionLang.model.CompositionDeclaration;
import language.compositionLang.model.ExternalProcessDeclaration;
import language.compositionLang.model.InstanceDeclaration;
import language.compositionLang.model.Model;
import language.compositionLang.model.ModelFactory;
import language.compositionLang.model.VariableDeclaration;
import language.compositionLang.model.VariableReference;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;

public class CompositionLangBuilderAST
extends CompositionLangBaseListener {
    public ParseTreeProperty<Object> values = new ParseTreeProperty();
    Map<String, ExternalProcessDeclaration> name2process = new HashMap<String, ExternalProcessDeclaration>();
    Map<String, VariableDeclaration> name2variable = new HashMap<String, VariableDeclaration>();
    Map<String, Integer> processName2instanceIndex = new HashMap<String, Integer>();
    ModelFactory factory = ModelFactory.eINSTANCE;

    public void setValue(ParseTree node, Object value) {
        this.values.put(node, value);
    }

    public Object getValue(ParseTree node) {
        return this.values.get(node);
    }

    public <T> T getValue(ParseTree node, Class<T> type) {
        if (node == null) {
            return null;
        }
        Object e = this.values.get(node);
        if (type.isAssignableFrom(e.getClass())) {
            return type.cast(e);
        }
        return null;
    }

    @Override
    public void exitLanguageID(CompositionLangParser.LanguageIDContext ctx) {
        this.setValue((ParseTree)ctx, ctx.IDENTIFIER().getText());
    }

    @Override
    public void exitVariableID(CompositionLangParser.VariableIDContext ctx) {
        VariableReference value = this.factory.createVariableReference();
        value.setDeclaration(this.name2variable.get(ctx.IDENTIFIER().getText()));
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitProcessID(CompositionLangParser.ProcessIDContext ctx) {
        this.setValue((ParseTree)ctx, this.name2process.get(ctx.IDENTIFIER().getText()));
    }

    @Override
    public void exitVariableDeclaration(CompositionLangParser.VariableDeclarationContext ctx) {
        VariableDeclaration value = this.factory.createVariableDeclaration();
        value.setName(ctx.IDENTIFIER().getText());
        value.setType(ctx.INT().getText());
        this.name2variable.put(value.getName(), value);
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitInstanceDeclaration(CompositionLangParser.InstanceDeclarationContext ctx) {
        InstanceDeclaration value = this.factory.createInstanceDeclaration();
        value.setProcessDeclaration(this.getValue((ParseTree)ctx.processID(), ExternalProcessDeclaration.class));
        if (ctx.IDENTIFIER() != null) {
            value.setName(ctx.IDENTIFIER().getText());
        } else {
            value.setName(this.getDefaultInstanceName(value.getProcessDeclaration()));
        }
        for (CompositionLangParser.VariableIDContext vctx : ctx.variableID()) {
            value.getArguments().add((Object)this.getValue((ParseTree)vctx, VariableReference.class));
        }
        this.setValue((ParseTree)ctx, value);
    }

    String getDefaultInstanceName(ExternalProcessDeclaration process) {
        Integer id = this.processName2instanceIndex.get(process.getName());
        if (id == null) {
            this.processName2instanceIndex.put(process.getName(), 0);
            return String.format("{%s}%d", process.getName(), 0);
        }
        Integer n = id;
        Integer n2 = id = Integer.valueOf(id + 1);
        this.processName2instanceIndex.put(process.getName(), id);
        return String.format("{%s}%d", process.getName(), id);
    }

    @Override
    public void exitProcessDeclaration(CompositionLangParser.ProcessDeclarationContext ctx) {
        ExternalProcessDeclaration value = this.factory.createExternalProcessDeclaration();
        value.setLanguageID(this.getValue((ParseTree)ctx.languageID(), String.class));
        value.setName(ctx.IDENTIFIER(0).getText());
        value.setOriginalName(ctx.IDENTIFIER(1).getText());
        String address = ctx.STRING().getText();
        value.setAddress(address.substring(1, address.length() - 1));
        this.name2process.put(value.getName(), value);
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitCompositeDeclaration(CompositionLangParser.CompositeDeclarationContext ctx) {
        CompositionDeclaration value = this.factory.createCompositionDeclaration();
        value.setName(ctx.IDENTIFIER().getText());
        for (CompositionLangParser.VariableDeclarationContext vctx : ctx.variableDeclaration()) {
            value.getVariables().add((Object)this.getValue((ParseTree)vctx, VariableDeclaration.class));
        }
        for (CompositionLangParser.InstanceDeclarationContext ictx : ctx.instanceDeclaration()) {
            value.getInstances().add((Object)this.getValue((ParseTree)ictx, InstanceDeclaration.class));
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitModel(CompositionLangParser.ModelContext ctx) {
        Model value = this.factory.createModel();
        for (CompositionLangParser.ProcessDeclarationContext pctx : ctx.processDeclaration()) {
            value.getProcesses().add((Object)this.getValue((ParseTree)pctx, ExternalProcessDeclaration.class));
        }
        value.setComposition(this.getValue((ParseTree)ctx.compositeDeclaration(), CompositionDeclaration.class));
        this.setValue((ParseTree)ctx, value);
    }
}

