/*
 * Decompiled with CFR 0.152.
 */
package obp.LTL.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.LTL.model.Atom;
import obp.LTL.model.Expression;
import obp.LTL.model.ModelVisitor;
import obp.LTL.model.NamedElement;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class FormulaDeclaration
extends NamedElement
implements BoostObject {
    private final List<Atom> atomsList = new ArrayList<Atom>();
    private Expression expression;

    public FormulaDeclaration() {
    }

    protected FormulaDeclaration(Boost boost) {
        super(boost);
        for (Atom oneChild : BoostUtil.readObjectList((Boost)boost, Atom.class)) {
            this.atomsList.add(oneChild);
        }
        this.expression = (Expression)boost.readObject(Expression.class);
    }

    public List<Atom> getAtomsList() {
        return Collections.unmodifiableList(this.atomsList);
    }

    public int getAtomsCount() {
        return this.atomsList.size();
    }

    public Atom getAtoms(int index) {
        if (index < 0 || index >= this.getAtomsCount()) {
            return null;
        }
        return this.atomsList.get(index);
    }

    public void addAtoms(Atom newValue) {
        this.addAtoms(this.getAtomsCount(), newValue);
    }

    public void addAtoms(int index, Atom newValue) {
        this.atomsList.add(index, newValue);
    }

    public Atom setAtoms(int index, Atom newValue) {
        return this.atomsList.set(index, newValue);
    }

    public void addAllAtoms(Collection<Atom> toAddList) {
        for (Atom newValue : toAddList) {
            this.addAtoms(this.getAtomsCount(), newValue);
        }
    }

    public void removeAtoms(Atom value) {
        int index = this.atomsList.indexOf(value);
        if (index >= 0) {
            this.removeAtoms(index);
        }
    }

    public void removeAtoms(int index) {
        this.atomsList.remove(index);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression newValue) {
        if (this.expression == null ? newValue != null : !this.expression.equals(newValue)) {
            this.expression = newValue;
        }
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.atomsList);
        boost.writeObject((BoostObject)this.expression);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitFormulaDeclaration(this);
    }
}

