/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.xml.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.petitparser.grammar.xml.ast.XmlNode;

public abstract class XmlParent
extends XmlNode {
    private final List<XmlNode> children;

    public XmlParent(Collection<XmlNode> children) {
        this.children = new ArrayList<XmlNode>(children);
        for (XmlNode child : children) {
            child.setParent(this);
        }
    }

    @Override
    public List<XmlNode> getChildren() {
        return this.children;
    }

    @Override
    public void writeTo(StringBuffer buffer) {
        for (XmlNode node : this.getChildren()) {
            node.writeTo(buffer);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        XmlParent other = (XmlParent)obj;
        return this.children.equals(other.children);
    }

    public int hashCode() {
        return this.children.size();
    }
}

