/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.explorer;

import java.io.File;
import java.io.FileInputStream;
import obp.cc.ConcreteContext;
import obp.explorer.ConfsFileHandler;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.simulation.InteractiveSimulator;
import obp.explorer.runtime.simulation.SimulationResult;
import obp.ui.explorer.ConfsFileHandlerController;
import obp.util.ConcreteContextUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.field.BorderField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;

public class SimulationController
extends Controller<InteractiveSimulator> {
    private final ErrorHandler errorHandler;
    private ListField<Transition> fireableField;
    Controller<ConfsFileHandler> configController;
    private SimulationResult result;
    private CompositeField compositeField;

    public void start() {
    }

    private InteractiveSimulator createSimulator() {
        try {
            String rootName = "cruisecontrol_v1.CruiseControl_v1Root";
            String programPath = "/Users/ciprian/Playfield/DEPARTS/ws_obp_abcd1/ABCDCompiler/examples/fiacre/cruiseControl_v1.obp/bin";
            String ccFile = "/Users/ciprian/Playfield/DEPARTS/ws_obp_abcd1/ABCDCompiler/examples/fiacre/cruiseControl_v1.obp/smart_rs2_ds1_p2_b3.cc";
            ProgramLoader.FromClass loader = new ProgramLoader.FromClass(rootName, new File(programPath));
            ConcreteContext cc = ConcreteContextUtil.loadCC(new FileInputStream(ccFile));
            InteractiveSimulator simulator = new InteractiveSimulator(loader, cc);
            simulator.setConfigurationOutputFile(new File("/Users/ciprian/Desktop/toto.obp/confs/sim.confs"));
            simulator.start();
            return simulator;
        }
        catch (Exception e) {
            this.errorHandler.handleError(2, "IO error\n");
            return null;
        }
    }

    public SimulationController(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.setSubject(this.createSimulator());
    }

    public CompositeField createFields() {
        this.fireableField = new ListField<Transition>(null, 2){

            public String getText(Transition element) {
                return ((InteractiveSimulator)SimulationController.this.getSubject()).transitionString(element);
            }
        };
        this.fireableField.addAction((Action)new Action.Stub("(re-)start"){

            public int run(ActionMonitor monitor) {
                if (SimulationController.this.getSubject() == null) {
                    return 1;
                }
                SimulationController.this.result = null;
                SimulationController.this.setSubject(SimulationController.this.createSimulator());
                SimulationController.this.refreshFields();
                return 1;
            }
        });
        int style = 90;
        this.fireableField.addAction((Action)new Action.Stub("Step", style){

            public int getVisibility() {
                return SimulationController.this.fireableField.getSingleSelection() == null ? 2 : 1;
            }

            public int run(ActionMonitor monitor) {
                if (SimulationController.this.getSubject() == null) {
                    return 1;
                }
                SimulationController.this.result = ((InteractiveSimulator)SimulationController.this.getSubject()).nextWith((Transition)SimulationController.this.fireableField.getSingleSelection());
                SimulationController.this.errorHandler.handleError(0, "currentConfiguration: " + ((InteractiveSimulator)SimulationController.this.getSubject()).currentConfiguration.id + "\n");
                SimulationController.this.refreshFields();
                return 1;
            }
        });
        this.fireableField.addAction((Action)new Action.Stub("Step Random)", style){

            public int getVisibility() {
                return !SimulationController.this.fireableField.getValue().isEmpty() ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                if (SimulationController.this.getSubject() == null) {
                    return 1;
                }
                SimulationController.this.result = ((InteractiveSimulator)SimulationController.this.getSubject()).nextRandom();
                SimulationController.this.errorHandler.handleError(0, "currentConfiguration: " + ((InteractiveSimulator)SimulationController.this.getSubject()).currentConfiguration.id + "\n");
                SimulationController.this.refreshFields();
                return 1;
            }
        });
        this.fireableField.addAction((Action)new Action.Stub("Random)", style){

            public int getVisibility() {
                return !SimulationController.this.fireableField.getValue().isEmpty() ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                if (SimulationController.this.getSubject() == null) {
                    return 1;
                }
                SimulationController.this.result = ((InteractiveSimulator)SimulationController.this.getSubject()).toEndRandom();
                SimulationController.this.refreshFields();
                return 1;
            }
        });
        this.configController = new ConfsFileHandlerController(this.errorHandler);
        CompositeField field = this.configController.createFields();
        BorderField simField = new BorderField(2, (Field)field);
        simField.setWest(this.fireableField, 40);
        this.compositeField = new CompositeField("Simulation", 0, new Field[]{simField});
        field.addListener(this.configController.createListener(this.compositeField.getActionExecuter()));
        this.configController.refreshFields();
        return this.compositeField;
    }

    public void refreshFields() {
        if (this.getSubject() == null) {
            this.compositeField.setEnable(false);
            return;
        }
        this.fireableField.setValue(((InteractiveSimulator)this.getSubject()).getReallyFireable());
        try {
            this.configController.setSubject((Object)(this.result.getExplorerResult() == null ? null : new ConfsFileHandler(this.result.getExplorerResult())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.configController.refreshFields();
    }

    public boolean updateSubject(Field field) {
        return true;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

