/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.Color;
import java.util.Date;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class Console
extends JTextPane {
    private static final long serialVersionUID = -2751883001186368406L;
    private Style info = null;
    private Style error = null;

    public Console() {
        Style defaut = this.getStyle("default");
        this.info = this.addStyle("info", defaut);
        StyleConstants.setForeground(this.info, Color.black);
        this.error = this.addStyle("error", this.info);
        StyleConstants.setForeground(this.error, Color.RED);
        this.setAutoscrolls(true);
        this.setEditable(false);
    }

    public void addText(String msg) {
        Document doc = this.getDocument();
        String text = new Date() + ": " + msg + "\n";
        try {
            doc.insertString(doc.getLength(), text, this.info);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        JTabbedPane parent = (JTabbedPane)this.getParent().getParent().getParent();
        parent.setSelectedIndex(0);
    }

    public void addTextError(String msg) {
        Document doc = this.getDocument();
        String text = new Date() + ": " + msg + "\n";
        try {
            doc.insertString(doc.getLength(), text, this.error);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        JTabbedPane parent = (JTabbedPane)this.getParent().getParent().getParent();
        parent.setSelectedIndex(0);
    }

    public void clear() {
        this.setText("");
    }
}

