/*
 * Decompiled with CFR 0.152.
 */
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class NQueens {
    static BDDFactory B;
    static boolean TRACE;
    static int N;
    static BDD[][] X;
    static BDD queen;
    static BDD solution;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("USAGE:  java NQueens N");
            return;
        }
        N = Integer.parseInt(args[0]);
        if (N <= 0) {
            System.err.println("USAGE:  java NQueens N");
            return;
        }
        TRACE = true;
        long time = System.currentTimeMillis();
        NQueens.runTest();
        NQueens.freeAll();
        time = System.currentTimeMillis() - time;
        System.out.println("Time: " + (double)time / 1000.0 + " seconds");
        BDDFactory.CacheStats cachestats = B.getCacheStats();
        if (cachestats != null && cachestats.uniqueAccess > 0) {
            System.out.println(cachestats);
        }
        B.done();
        B = null;
    }

    public static double runTest() {
        int j;
        int i;
        if (B == null) {
            String numOfNodes = System.getProperty("bddnodes");
            int numberOfNodes = numOfNodes == null ? (int)Math.pow(4.42, N - 6) * 1000 : Integer.parseInt(numOfNodes);
            String cache = System.getProperty("bddcache");
            int cacheSize = cache == null ? 1000 : Integer.parseInt(cache);
            numberOfNodes = Math.max(1000, numberOfNodes);
            B = BDDFactory.init(numberOfNodes, cacheSize);
        }
        if (B.varNum() < N * N) {
            B.setVarNum(N * N);
        }
        queen = B.one();
        X = new BDD[N][N];
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                NQueens.X[i][j] = B.ithVar(i * N + j);
            }
        }
        for (i = 0; i < N; ++i) {
            BDD e = B.zero();
            for (j = 0; j < N; ++j) {
                e.orWith(X[i][j].id());
            }
            queen.andWith(e);
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                if (TRACE) {
                    System.out.print("Adding position " + i + "," + j + "   \r");
                }
                NQueens.build(i, j);
            }
        }
        solution = queen.satOne();
        double result = queen.satCount();
        if (TRACE) {
            System.out.println("There are " + (long)result + " solutions.");
            double result2 = solution.satCount();
            System.out.println("Here is " + (long)result2 + " solution:");
            solution.printSet();
            System.out.println();
        }
        return result;
    }

    public static void freeAll() {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                X[i][j].free();
            }
        }
        queen.free();
        solution.free();
    }

    static void build(int i, int j) {
        BDD u;
        int k;
        BDD u2;
        BDD a = B.one();
        BDD b = B.one();
        BDD c = B.one();
        BDD d = B.one();
        for (int l = 0; l < N; ++l) {
            if (l == j) continue;
            u2 = X[i][l].apply(X[i][j], BDDFactory.nand);
            a.andWith(u2);
        }
        for (k = 0; k < N; ++k) {
            if (k == i) continue;
            u2 = X[i][j].apply(X[k][j], BDDFactory.nand);
            b.andWith(u2);
        }
        for (k = 0; k < N; ++k) {
            int ll = k - i + j;
            if (ll < 0 || ll >= N || k == i) continue;
            u = X[i][j].apply(X[k][ll], BDDFactory.nand);
            c.andWith(u);
        }
        for (k = 0; k < N; ++k) {
            int ll = i + j - k;
            if (ll < 0 || ll >= N || k == i) continue;
            u = X[i][j].apply(X[k][ll], BDDFactory.nand);
            d.andWith(u);
        }
        c.andWith(d);
        b.andWith(c);
        a.andWith(b);
        queen.andWith(a);
    }
}

