/*
 * Decompiled with CFR 0.152.
 */
package obp.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import obp.cdl.parser.CDLLexer;
import obp.cdl.parser.CDLParser;
import obp.predicate.AllPredicate;
import obp.predicate.ArrayAccess;
import obp.predicate.AtomicAccess;
import obp.predicate.FieldAccess;
import obp.predicate.LiteralComparisonPredicate;
import obp.predicate.LiteralEqualityPredicate;
import obp.predicate.LogicPredicate;
import obp.predicate.Predicate;
import obp.predicate.PredicateReference;
import obp.predicate.PredicateVisitor;
import obp.predicate.StatePredicate;
import obp.predicate.SystemAccess;
import obp.predicate.VariableComparisonPredicate;
import obp.predicate.VariableEqualityPredicate;
import obp.util.CDLUtil;
import obp.util.LiteralUtil;

public class PredicateUtil
implements PredicateVisitor {
    private final StringBuilder string = new StringBuilder();

    public static String printPredicate(Predicate predicate) {
        PredicateUtil util = new PredicateUtil();
        predicate.accept(util);
        return util.string.toString();
    }

    public static Predicate readPredicate(String source) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(source.getBytes("UTF-8")));
        CDLLexer lexer = new CDLLexer(in);
        CDLParser parser = new CDLParser();
        Predicate predicate = null;
        try {
            predicate = (Predicate)parser.parse(lexer, (short)81);
        }
        catch (RuntimeException e) {
            throw new Exception(e.getMessage());
        }
        ((InputStream)in).close();
        return predicate;
    }

    public static String printAccess(SystemAccess access) {
        PredicateUtil util = new PredicateUtil();
        access.accept(util);
        return util.string.toString();
    }

    public static SystemAccess readAccess(String source) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(source.getBytes("UTF-8")));
        CDLLexer lexer = new CDLLexer(in);
        CDLParser parser = new CDLParser();
        SystemAccess access = null;
        try {
            access = (SystemAccess)parser.parse(lexer, (short)82);
        }
        catch (RuntimeException e) {
            throw new Exception(e.getMessage());
        }
        ((InputStream)in).close();
        return access;
    }

    private PredicateUtil() {
    }

    @Override
    public void visitAllPredicate(AllPredicate toVisit) {
        this.string.append("all");
    }

    @Override
    public void visitPredicateReference(PredicateReference toVisit) {
        this.string.append(toVisit.getName());
    }

    @Override
    public void visitStatePredicate(StatePredicate toVisit) {
        this.string.append(CDLUtil.toString(toVisit.getPid()));
        this.string.append("@");
        this.string.append(toVisit.getState());
    }

    @Override
    public void visitLiteralEqualityPredicate(LiteralEqualityPredicate toVisit) {
        toVisit.getLeft().accept(this);
        this.string.append(" = ");
        this.string.append(LiteralUtil.print(toVisit.getRight()));
    }

    @Override
    public void visitVariableEqualityPredicate(VariableEqualityPredicate toVisit) {
        toVisit.getLeft().accept(this);
        this.string.append(" = ");
        toVisit.getRight().accept(this);
    }

    @Override
    public void visitSystemAccess(SystemAccess toVisit) {
        this.string.append(CDLUtil.toString(toVisit.getPid()));
        this.string.append(":");
        int startLength = this.string.length();
        for (AtomicAccess access : toVisit.getAccessList()) {
            if (this.string.length() > startLength) {
                this.string.append(".");
            }
            access.accept(this);
        }
    }

    @Override
    public void visitFieldAccess(FieldAccess toVisit) {
        this.string.append(toVisit.getName());
    }

    @Override
    public void visitArrayAccess(ArrayAccess toVisit) {
        this.string.append(toVisit.getName());
        this.string.append("[");
        this.string.append(toVisit.getIndex());
        this.string.append("]");
    }

    @Override
    public void visitLogicPredicate(LogicPredicate toVisit) {
        switch (toVisit.getOperator()) {
            case NOT: {
                this.string.append("not ");
                toVisit.getLeft().accept(this);
                break;
            }
            case AND: {
                toVisit.getLeft().accept(this);
                this.string.append(" and ");
                toVisit.getRight().accept(this);
                break;
            }
            case OR: {
                toVisit.getLeft().accept(this);
                this.string.append(" or ");
                toVisit.getRight().accept(this);
                break;
            }
        }
    }

    @Override
    public void visitVariableComparisonPredicate(VariableComparisonPredicate toVisit) {
        toVisit.getLeft().accept(this);
        switch (toVisit.getOperator()) {
            case LESSER: {
                this.string.append(" < ");
                break;
            }
            case LESSER_OR_EQUAL: {
                this.string.append(" <= ");
                break;
            }
            case GREATER: {
                this.string.append(" > ");
                break;
            }
            case GREATER_OR_EQUAL: {
                this.string.append(" >= ");
            }
        }
        toVisit.getRight().accept(this);
    }

    @Override
    public void visitLiteralComparisonPredicate(LiteralComparisonPredicate toVisit) {
        toVisit.getLeft().accept(this);
        switch (toVisit.getOperator()) {
            case LESSER: {
                this.string.append(" < ");
                break;
            }
            case LESSER_OR_EQUAL: {
                this.string.append(" <= ");
                break;
            }
            case GREATER: {
                this.string.append(" > ");
                break;
            }
            case GREATER_OR_EQUAL: {
                this.string.append(" >= ");
            }
        }
        this.string.append(LiteralUtil.print(toVisit.getRight()));
    }
}

