/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Composition;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.Priority;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class ComponentDecl
extends NodeDecl
implements BoostObject {
    private Composition body;
    private final List<Priority> priorityList = new ArrayList<Priority>();

    public ComponentDecl() {
    }

    protected ComponentDecl(Boost boost) {
        super(boost);
        this.body = (Composition)boost.readObject(Composition.class);
        for (Priority oneChild : BoostUtil.readObjectList((Boost)boost, Priority.class)) {
            this.priorityList.add(oneChild);
        }
    }

    public Composition getBody() {
        return this.body;
    }

    public void setBody(Composition newValue) {
        if (this.body == null ? newValue != null : !this.body.equals(newValue)) {
            this.body = newValue;
        }
    }

    public List<Priority> getPriorityList() {
        return Collections.unmodifiableList(this.priorityList);
    }

    public int getPriorityCount() {
        return this.priorityList.size();
    }

    public Priority getPriority(int index) {
        if (index < 0 || index >= this.getPriorityCount()) {
            return null;
        }
        return this.priorityList.get(index);
    }

    public void addPriority(Priority newValue) {
        this.addPriority(this.getPriorityCount(), newValue);
    }

    public void addPriority(int index, Priority newValue) {
        this.priorityList.add(index, newValue);
    }

    public Priority setPriority(int index, Priority newValue) {
        return this.priorityList.set(index, newValue);
    }

    public void addAllPriority(Collection<Priority> toAddList) {
        for (Priority newValue : toAddList) {
            this.addPriority(this.getPriorityCount(), newValue);
        }
    }

    public void removePriority(Priority value) {
        int index = this.priorityList.indexOf(value);
        if (index >= 0) {
            this.removePriority(index);
        }
    }

    public void removePriority(int index) {
        this.priorityList.remove(index);
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        boost.writeObject((BoostObject)this.body);
        BoostUtil.writeObjectCollection((Boost)boost, this.priorityList);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitComponentDecl(this);
    }
}

