/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.CdlVisitor;
import obp.cdl.Guard;
import obp.cdl.GuardOperator;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class ComposedGuard
extends Guard
implements BoostObject {
    private GuardOperator operator;
    private final List<Guard> childList = new ArrayList<Guard>();

    public ComposedGuard() {
    }

    protected ComposedGuard(Boost boost) {
        super(boost);
        this.operator = (GuardOperator)boost.readEnum(GuardOperator.class);
        for (Guard oneChild : BoostUtil.readObjectList((Boost)boost, Guard.class)) {
            this.childList.add(oneChild);
        }
    }

    public GuardOperator getOperator() {
        return this.operator;
    }

    public void setOperator(GuardOperator newValue) {
        if (this.operator == null ? newValue != null : !this.operator.equals((Object)newValue)) {
            this.operator = newValue;
        }
    }

    public List<Guard> getChildList() {
        return Collections.unmodifiableList(this.childList);
    }

    public int getChildCount() {
        return this.childList.size();
    }

    public Guard getChild(int index) {
        if (index < 0 || index >= this.getChildCount()) {
            return null;
        }
        return this.childList.get(index);
    }

    public void addChild(Guard newValue) {
        this.addChild(this.getChildCount(), newValue);
    }

    public void addChild(int index, Guard newValue) {
        this.childList.add(index, newValue);
    }

    public Guard setChild(int index, Guard newValue) {
        return this.childList.set(index, newValue);
    }

    public void addAllChild(Collection<Guard> toAddList) {
        for (Guard newValue : toAddList) {
            this.addChild(this.getChildCount(), newValue);
        }
    }

    public void removeChild(Guard value) {
        int index = this.childList.indexOf(value);
        if (index >= 0) {
            this.removeChild(index);
        }
    }

    public void removeChild(int index) {
        this.childList.remove(index);
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        boost.writeEnum((Enum)this.operator);
        BoostUtil.writeObjectCollection((Boost)boost, this.childList);
    }

    @Override
    public void accept(CdlVisitor visitor) {
        visitor.visitComposedGuard(this);
    }
}

