/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.expression;

import java.util.Set;
import spinja.promela.compiler.parser.MyParseException;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.promela.compiler.variable.VariableType;

public abstract class Expression {
    private final Token token;

    public Expression(Token token) {
        this.token = token;
    }

    public String getBoolExpression() throws ParseException {
        return "(" + this.getIntExpression() + " != 0 )";
    }

    public int getConstantValue() throws ParseException {
        throw new MyParseException("Constant value not be determened on compile-time.", this.getToken());
    }

    public String getIntExpression() throws ParseException {
        return "(" + this.getBoolExpression() + " ? 1 : 0)";
    }

    public abstract VariableType getResultType() throws ParseException;

    public String getSideEffect() throws ParseException {
        return null;
    }

    public final Token getToken() {
        return this.token;
    }

    public abstract Set<VariableAccess> readVariables();

    public String toString() {
        try {
            return this.getIntExpression();
        }
        catch (ParseException parseException) {
            return "";
        }
    }
}

