/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.expression;

import java.util.HashSet;
import java.util.Set;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.promela.compiler.variable.VariableType;

public class ConstantExpression
extends Expression {
    private static final long serialVersionUID = -5861698132204844795L;
    private final int nr;

    public ConstantExpression(Token token, int n) {
        super(token);
        this.nr = n;
    }

    @Override
    public String getBoolExpression() {
        switch (this.getToken().kind) {
            case 45: {
                return "true";
            }
            case 46: {
                return "false";
            }
            case 47: {
                return "true";
            }
            case 90: {
                return this.nr != 0 ? "true" : "false";
            }
        }
        return "true";
    }

    @Override
    public int getConstantValue() {
        return this.nr;
    }

    @Override
    public String getIntExpression() {
        switch (this.getToken().kind) {
            case 45: {
                return "1";
            }
            case 46: {
                return "0";
            }
            case 47: {
                return "1";
            }
            case 90: {
                return Integer.toString(this.getNumber());
            }
        }
        return "1";
    }

    public int getNumber() {
        return this.nr;
    }

    @Override
    public VariableType getResultType() {
        return VariableType.INT;
    }

    @Override
    public String getSideEffect() {
        return null;
    }

    @Override
    public Set<VariableAccess> readVariables() {
        return new HashSet<VariableAccess>();
    }

    @Override
    public String toString() {
        switch (this.getToken().kind) {
            case 45: {
                return "true";
            }
            case 46: {
                return "false";
            }
            case 47: {
                return "skip";
            }
            case 90: {
                return Integer.toString(this.getNumber());
            }
        }
        return "1";
    }
}

