/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.json;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.petitparser.parser.Parser;
import org.petitparser.parser.primitive.CharacterParser;
import org.petitparser.parser.primitive.StringParser;
import org.petitparser.tools.CompositeParser;

public class JsonGrammar
extends CompositeParser {
    protected static final Map<Character, Character> ESCAPE_TABLE = JsonGrammar.createEscapeTable();
    protected static final Function<Character, Character> ESCAPE_TABLE_FUNCTION = ESCAPE_TABLE::get;

    protected static Map<Character, Character> createEscapeTable() {
        HashMap<Character, Character> table = new HashMap<Character, Character>();
        table.put(Character.valueOf('\\'), Character.valueOf('\\'));
        table.put(Character.valueOf('/'), Character.valueOf('/'));
        table.put(Character.valueOf('\"'), Character.valueOf('\"'));
        table.put(Character.valueOf('b'), Character.valueOf('\b'));
        table.put(Character.valueOf('f'), Character.valueOf('\f'));
        table.put(Character.valueOf('n'), Character.valueOf('\n'));
        table.put(Character.valueOf('r'), Character.valueOf('\r'));
        table.put(Character.valueOf('t'), Character.valueOf('\t'));
        return Collections.unmodifiableMap(table);
    }

    protected static String listToString(Collection<Character> characters) {
        StringBuilder builder = new StringBuilder(characters.size());
        characters.forEach(builder::append);
        return builder.toString();
    }

    protected void initialize() {
        this.def("start", this.ref("value").end());
        this.def("array", CharacterParser.of((char)'[').trim().seq(new Parser[]{this.ref("elements").optional()}).seq(new Parser[]{CharacterParser.of((char)']').trim()}));
        this.def("elements", this.ref("value").separatedBy(CharacterParser.of((char)',').trim()));
        this.def("members", this.ref("pair").separatedBy(CharacterParser.of((char)',').trim()));
        this.def("object", CharacterParser.of((char)'{').trim().seq(new Parser[]{this.ref("members").optional()}).seq(new Parser[]{CharacterParser.of((char)'}').trim()}));
        this.def("pair", this.ref("stringToken").seq(new Parser[]{CharacterParser.of((char)':').trim()}).seq(new Parser[]{this.ref("value")}));
        this.def("value", this.ref("stringToken").or(new Parser[]{this.ref("numberToken")}).or(new Parser[]{this.ref("trueToken")}).or(new Parser[]{this.ref("falseToken")}).or(new Parser[]{this.ref("nullToken")}).or(new Parser[]{this.ref("object")}).or(new Parser[]{this.ref("array")}));
        this.def("trueToken", StringParser.of((String)"true").flatten().trim());
        this.def("falseToken", StringParser.of((String)"false").flatten().trim());
        this.def("nullToken", StringParser.of((String)"null").flatten().trim());
        this.def("stringToken", this.ref("stringPrimitive").flatten().trim());
        this.def("numberToken", this.ref("numberPrimitive").flatten().trim());
        this.def("characterPrimitive", this.ref("characterEscape").or(new Parser[]{this.ref("characterOctal")}).or(new Parser[]{this.ref("characterNormal")}));
        this.def("characterEscape", CharacterParser.of((char)'\\').seq(new Parser[]{CharacterParser.anyOf((String)JsonGrammar.listToString(ESCAPE_TABLE.keySet()))}));
        this.def("characterOctal", StringParser.of((String)"\\u").seq(new Parser[]{CharacterParser.pattern((String)"0-9A-Fa-f").times(4).flatten()}));
        this.def("characterNormal", CharacterParser.anyOf((String)"\"\\").neg());
        this.def("numberPrimitive", CharacterParser.of((char)'-').optional().seq(new Parser[]{CharacterParser.of((char)'0').or(new Parser[]{CharacterParser.digit().plus()})}).seq(new Parser[]{CharacterParser.of((char)'.').seq(new Parser[]{CharacterParser.digit().plus()}).optional()}).seq(new Parser[]{CharacterParser.anyOf((String)"eE").seq(new Parser[]{CharacterParser.anyOf((String)"-+").optional()}).seq(new Parser[]{CharacterParser.digit().plus()}).optional()}));
        this.def("stringPrimitive", CharacterParser.of((char)'\"').seq(new Parser[]{this.ref("characterPrimitive").star()}).seq(new Parser[]{CharacterParser.of((char)'\"')}));
    }
}

