/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.actions;

import java.util.Collections;
import java.util.List;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.expression.Identifier;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.util.StringWriter;

public class AssertAction
extends Action {
    private final Expression expr;

    public AssertAction(Token token, Expression expression) {
        super(token);
        this.expr = expression;
    }

    @Override
    public String getEnabledExpression() {
        return null;
    }

    @Override
    public boolean isLocal(Proctype proctype) {
        for (VariableAccess variableAccess : this.expr.readVariables()) {
            if (proctype.hasVariable(variableAccess.getVar().getName())) continue;
            return false;
        }
        return super.isLocal(proctype);
    }

    @Override
    public void printTakeStatement(StringWriter stringWriter) throws ParseException {
        stringWriter.appendLine("if(!", this.expr.getBoolExpression(), ") throw new AssertionException(\"", this.expr.toString(), "\");");
    }

    public List<Identifier> getChangedVariables() {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        return "assert " + this.expr.toString();
    }
}

