/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import java.util.HashSet;
import java.util.Set;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.ABCDWalker;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.kernel.Element;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.statements.WaitStmt;

public class TimedChecker
extends ABCDVisitor.Stub {
    private boolean timed = false;
    private Set<Element> visited = new HashSet<Element>();

    public static boolean isTimed(ABCDSystem sys) {
        TimedChecker checker = new TimedChecker();
        sys.accept(checker);
        return checker.isTimed();
    }

    public boolean isTimed() {
        return this.timed;
    }

    @Override
    public void visitABCDSystem(ABCDSystem toVisit) {
        if (this.visited.contains(toVisit)) {
            return;
        }
        this.visited.add(toVisit);
        this.timed = false;
        for (ProcessInstance pI : toVisit.getCompositionList()) {
            pI.accept(this);
            if (!this.timed) continue;
            break;
        }
    }

    @Override
    public void visitProcessInstance(ProcessInstance toVisit) {
        if (this.visited.contains(toVisit)) {
            return;
        }
        this.visited.add(toVisit);
        toVisit.getProcess().accept(this);
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        if (this.visited.contains(toVisit)) {
            return;
        }
        this.visited.add(toVisit);
        for (Transition t : toVisit.getTransitionsList()) {
            t.getBehavior().accept(new ABCDWalker(new ABCDVisitor.Stub(){

                @Override
                public void visitWaitStmt(WaitStmt toVisit) {
                    TimedChecker.this.timed = true;
                }
            }));
            if (!this.timed) continue;
            break;
        }
    }
}

