/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import obp.simulation.resource.SimulationResources;

public class SimulationMenu
extends JMenuBar {
    private static final long serialVersionUID = 7840477273727593082L;
    private JMenuItem load;
    private JMenuItem save;
    private JMenuItem saveAs;
    private JMenuItem preference;
    private JMenuItem dotExport;
    private JMenuItem svgExport;
    private JMenuItem close;
    private JMenuItem fiacre;
    private JMenuItem clearConsole;
    private JMenuItem displayTrace;
    private JMenuItem displayObservers;
    private JMenuItem hideObservers;

    public SimulationMenu() {
        this.initMenu();
    }

    public void initMenu() {
        JMenu file = new JMenu("File");
        this.load = new JMenuItem("Load", SimulationResources.loadIcon);
        this.load.setActionCommand("load");
        this.save = new JMenuItem("Save", SimulationResources.saveIcon);
        this.save.setActionCommand("save");
        this.saveAs = new JMenuItem("Save as ...", SimulationResources.saveAsIcon);
        this.saveAs.setActionCommand("saveAs");
        this.preference = new JMenuItem("Preferences", SimulationResources.prefIcon);
        this.preference.setActionCommand("preference");
        JMenu export = new JMenu("Export graph");
        export.setIcon(SimulationResources.exportIcon);
        this.dotExport = new JMenuItem("dot ...");
        this.dotExport.setActionCommand("exportToDot");
        this.svgExport = new JMenuItem("svg ...");
        this.svgExport.setActionCommand("exportToSvg");
        export.add(this.dotExport);
        export.add(this.svgExport);
        this.close = new JMenuItem("Close", SimulationResources.exitIcon);
        this.close.setActionCommand("close");
        file.add(this.load);
        file.add(this.save);
        file.add(this.saveAs);
        file.add(new JSeparator());
        file.add(this.preference);
        file.add(new JSeparator());
        file.add(export);
        file.add(new JSeparator());
        file.add(this.close);
        this.add(new JMenu("OBP Simulation"));
        this.add(file);
        JMenu program = new JMenu("Program");
        this.fiacre = new JMenuItem("Display Frc");
        this.fiacre.setActionCommand("fiacreView");
        program.add(this.fiacre);
        program.add(new JMenuItem("Display Cdl"));
        this.add(program);
        JMenu view = new JMenu("View");
        this.displayTrace = new JMenuItem("Display Trace", SimulationResources.trace);
        this.displayTrace.setActionCommand("displayTrace");
        this.displayObservers = new JMenuItem("Display Observers", SimulationResources.observerIconO);
        this.displayObservers.setActionCommand("displayObservers");
        this.hideObservers = new JMenuItem("Hide Observers", SimulationResources.observerIconH);
        this.hideObservers.setActionCommand("hideObservers");
        this.clearConsole = new JMenuItem("Clear console", SimulationResources.clearIcon);
        this.clearConsole.setActionCommand("clearConsole");
        view.add(this.displayTrace);
        view.add(this.displayObservers);
        view.add(this.hideObservers);
        view.add(this.clearConsole);
        this.add(view);
        JMenu help = new JMenu("Help");
        help.add(new JMenuItem("about"));
        this.add(help);
    }

    public void addListener(ActionListener al) {
        this.load.addActionListener(al);
        this.save.addActionListener(al);
        this.saveAs.addActionListener(al);
        this.preference.addActionListener(al);
        this.dotExport.addActionListener(al);
        this.svgExport.addActionListener(al);
        this.close.addActionListener(al);
        this.fiacre.addActionListener(al);
        this.displayTrace.addActionListener(al);
        this.displayObservers.addActionListener(al);
        this.hideObservers.addActionListener(al);
        this.clearConsole.addActionListener(al);
    }

    public void desableObserverControl() {
        this.displayObservers.setEnabled(false);
        this.hideObservers.setEnabled(false);
    }
}

