/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi.try1;

import c.builder.CBuilder;
import c.model.ArgumentDeclaration;
import c.model.Block;
import c.model.CompilationUnit;
import c.model.Container;
import c.model.Declaration;
import c.model.Expression;
import c.model.ExternalType;
import c.model.FunctionCall;
import c.model.FunctionDeclaration;
import c.model.IncludeDeclaration;
import c.model.Literal;
import c.model.MacroCallStmt;
import c.model.Statement;
import c.model.StatementGroup;
import c.model.Type;
import c.model.UnaryExpression;
import c.model.VariableDeclaration;
import c.model.VariableReference;
import c.printer.CPrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.ffi.ExtractCTypes;
import obp.fiacre.ffi.FFIBindingGeneratorI;
import obp.fiacre.ffi.try1.TC2FiacreUnmarshaller;
import obp.fiacre.ffi.try1.TFiacre2CMarshaller;
import obp.fiacre.model.Array;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.ExternalArgument;
import obp.fiacre.model.ExternalFunctionDecl;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;

public class FFIBindingGenerator
implements FFIBindingGeneratorI {
    public boolean hasArray = false;
    public boolean usesFFI = false;
    int currentIdx;
    ExtractCTypes typeExtractor = new ExtractCTypes();
    public Map<Object, Type> typeMap;
    final CBuilder cBuilder = CBuilder.instance;
    CompilationUnit bindingUnit = this.cBuilder.compilationUnit();
    List<Declaration> ffiDeclarations = this.bindingUnit.getDeclarations();
    protected final ProgramGenerator caller;
    private File fiacreFile;
    Map<ExternalArgument, Field> earg2field = new HashMap<ExternalArgument, Field>();

    public FFIBindingGenerator(ProgramGenerator caller, File fiacreFile) {
        this.caller = caller;
        this.fiacreFile = fiacreFile;
    }

    @Override
    public void generateBindings(ExternalFunctionDecl fct) {
        this.usesFFI = true;
        this.typeMap = this.typeExtractor.extractTypes(fct, this.currentIdx);
        this.createFunction(fct);
    }

    public void createFunction(ExternalFunctionDecl fct) {
        FunctionDeclaration cFct = this.cBuilder.fdecl("JNIEXPORT", this.toJniType(fct.getReturnType()), "JNICALL", this.jniFunctionNamed(fct.getName()), this.bindingUnit);
        List<ArgumentDeclaration> args = cFct.getArguments();
        args.add(this.createEnvArgument());
        args.add(this.createClsArgument());
        args.add(this.createObjArgument());
        this.ffiDeclarations.add(cFct);
        this.createFunctionBody(fct, cFct);
    }

    void createFunctionBody(ExternalFunctionDecl fct, FunctionDeclaration cFct) {
        TFiacre2CMarshaller marshaller = null;
        StatementGroup marshallStmts = this.cBuilder.statementGroup(cFct);
        marshallStmts.getComment().add("marshalling code");
        cFct.getBody().add(marshallStmts);
        StatementGroup releaseStmts = this.cBuilder.statementGroup(cFct);
        releaseStmts.getComment().add("release statements");
        cFct.getBody().add(releaseStmts);
        TypeDecl singleArgType = null;
        if (fct.getArgCount() > 0) {
            singleArgType = this.synthesizeArgumentType(fct);
            this.typeExtractor.extractTypes(singleArgType, this.currentIdx);
            marshaller = new TFiacre2CMarshaller(singleArgType, this, marshallStmts, releaseStmts);
            singleArgType.accept(marshaller);
        }
        StatementGroup callFctStmts = this.cBuilder.statementGroup(cFct);
        callFctStmts.getComment().add("calling c code");
        cFct.getBody().add(1, callFctStmts);
        VariableDeclaration fctHandle = this.cBuilder.variable("(*fctHandle)()", this.toJniType(fct.getReturnType()));
        callFctStmts.getStatements().add(fctHandle);
        MacroCallStmt loadFct = this.cBuilder.macroCall("LOAD_FCT");
        Literal fctName = this.cBuilder.literal(fct.getExternalName().subSequence(1, fct.getExternalName().length() - 1).toString());
        loadFct.getArguments().add(fctName);
        callFctStmts.getStatements().add(loadFct);
        VariableDeclaration result = this.cBuilder.variable("result", this.toJniType(fct.getReturnType()));
        FunctionCall fctCall = this.cBuilder.functionCall("(*fctHandle)");
        for (ExternalArgument eArg : fct.getArgList()) {
            VariableReference vRef;
            VariableDeclaration cArg = marshaller.valueMap.get(eArg.getType());
            Expression cArgExp = vRef = this.cBuilder.reference(cArg);
            if (eArg.isWrite()) {
                UnaryExpression argExp = this.cBuilder.address(vRef);
                cArgExp = argExp;
            }
            fctCall.getArguments().add(cArgExp);
        }
        result.setInitialValue(fctCall);
        callFctStmts.getStatements().add(result);
        StatementGroup unmarshallStmts = this.cBuilder.statementGroup(cFct);
        unmarshallStmts.getComment().add("unmarshalling code");
        cFct.getBody().add(2, unmarshallStmts);
        TC2FiacreUnmarshaller unmarshaller = new TC2FiacreUnmarshaller(this, unmarshallStmts);
        unmarshaller.valueMap = marshaller.valueMap;
        unmarshaller.objectContext.push(marshaller.objectMap.get(singleArgType.getIs()));
        unmarshaller.absoluteName2index = marshaller.absoluteName2index;
        unmarshaller.absoluteName2object = marshaller.absoluteName2object;
        unmarshaller.absoluteNameStack.push(singleArgType.getName());
        unmarshaller.absoluteNameStack.push("rec");
        for (ExternalArgument eArg : fct.getArgList()) {
            if (!eArg.isWrite()) continue;
            VariableDeclaration cArg = marshaller.valueMap.get(eArg.getType());
            VariableReference vRef = this.cBuilder.reference(cArg);
            unmarshaller.valueContext.push(vRef);
            unmarshaller.absoluteNameStack.push(this.earg2field.get(eArg).getName());
            unmarshaller.indexContext.push(marshaller.indexMap.get(this.earg2field.get(eArg)));
            eArg.getType().accept(unmarshaller);
            unmarshaller.indexContext.pop();
            unmarshaller.absoluteNameStack.pop();
        }
        unmarshaller.absoluteNameStack.pop();
        unmarshaller.absoluteNameStack.pop();
        unmarshaller.objectContext.pop();
        cFct.getBody().add(this.cBuilder.returnStmt(this.cBuilder.reference(result)));
    }

    TypeDecl synthesizeArgumentType(ExternalFunctionDecl fct) {
        Record rec = new Record();
        int idx = 0;
        for (ExternalArgument eArg : fct.getArgList()) {
            Field field = new Field();
            field.setName("arg" + idx++);
            field.setType(eArg.getType());
            rec.addField(field);
            this.earg2field.put(eArg, field);
        }
        TypeDecl tD = new TypeDecl();
        tD.setIs(rec);
        tD.setName("arg_" + fct.getName());
        return tD;
    }

    public void addIncludes() {
        ArrayList<IncludeDeclaration> includes = new ArrayList<IncludeDeclaration>();
        includes.add(this.cBuilder.include("<stdlib.h>"));
        includes.add(this.cBuilder.include("<string.h>"));
        includes.add(this.cBuilder.include("<jni.h>"));
        includes.add(this.cBuilder.include("<common/loader.h>"));
        includes.add(this.cBuilder.include("<common/helpers.h>"));
        this.ffiDeclarations.addAll(0, includes);
    }

    public void addGlobals(File packagePath) {
        VariableDeclaration gLibHandle = this.cBuilder.variable("gLibHandle", this.cBuilder.voidPointerType(), this.cBuilder.nullLiteral());
        VariableDeclaration gLibPath = this.cBuilder.variable("gLibPath", this.cBuilder.arrayType(this.cBuilder.charType()), this.cBuilder.literal(this.fiacreFile.getParent() + "/libcprims.dylib"));
        VariableDeclaration gExceptionClass = this.cBuilder.variable("gExceptionClass", this.cBuilder.externalType("jclass"), this.cBuilder.nullLiteral());
        this.ffiDeclarations.add(0, gLibHandle);
        this.ffiDeclarations.add(0, gLibPath);
        this.ffiDeclarations.add(0, gExceptionClass);
    }

    String jniFunctionNamed(String name) {
        String basePackage = this.caller.basePackage == null ? "" : this.caller.basePackage.replaceAll("\\.", "_") + "_";
        return "Java_" + basePackage + this.caller.packageName + "_" + this.caller.getProgramName() + "_prim" + name;
    }

    private ArgumentDeclaration createEnvArgument() {
        return this.cBuilder.argumentDecl("env", this.cBuilder.pointerType(this.cBuilder.externalType("JNIEnv")));
    }

    private ArgumentDeclaration createClsArgument() {
        return this.cBuilder.argumentDecl("cls", this.cBuilder.externalType("jclass"));
    }

    private ArgumentDeclaration createObjArgument() {
        return this.cBuilder.argumentDecl("obj", this.cBuilder.externalType("jobject"));
    }

    private void addUnloadFunction() {
        FunctionDeclaration unloader = this.cBuilder.fdecl("JNIEXPORT", this.cBuilder.voidType(), "JNICALL", this.jniFunctionNamed("UnloadLibrary"), this.bindingUnit);
        List<ArgumentDeclaration> args = unloader.getArguments();
        args.add(this.createEnvArgument());
        args.add(this.createObjArgument());
        FunctionCall unloadLibaryCall = this.cBuilder.functionCall("unloadLibrary");
        unloadLibaryCall.getArguments().add(this.referenceTo("gLibHandle"));
        unloader.getBody().add(unloadLibaryCall);
        this.ffiDeclarations.add(unloader);
    }

    @Override
    public void emitBindings(File f) {
        if (!this.usesFFI) {
            return;
        }
        this.ffiDeclarations.addAll(0, this.typeExtractor.typeDeclarations);
        this.addGlobals(this.caller.getDestinationFile());
        this.addIncludes();
        this.addUnloadFunction();
        CPrinter cPrinter = new CPrinter();
        String emittedCode = cPrinter.emit(this.bindingUnit);
        try {
            File theFile = new File(f, "../bindings/ffi_bindings.c");
            theFile.getParentFile().mkdir();
            theFile.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(theFile));
            bw.append(emittedCode);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    VariableReference referenceTo(String declName) {
        ArgumentDeclaration gLibHandle = this.findDeclNamed(declName, ArgumentDeclaration.class);
        return this.cBuilder.reference(gLibHandle);
    }

    VariableReference referenceTo(String declName, Container context) {
        ArgumentDeclaration gLibHandle = this.findDeclNamed(declName, ArgumentDeclaration.class, context);
        return this.cBuilder.reference(gLibHandle);
    }

    <T extends Declaration> T findDeclNamed(String name, Class<T> type) {
        for (Declaration decl : this.ffiDeclarations) {
            if (!type.isAssignableFrom(decl.getClass()) || !decl.getName().equals(name)) continue;
            return (T)((Declaration)type.cast(decl));
        }
        return null;
    }

    <T extends Declaration> T findDeclNamed(String name, Class<T> type, List<? extends Statement> list) {
        for (Statement statement : list) {
            if (!type.isAssignableFrom(statement.getClass()) || !((Declaration)statement).getName().equals(name)) continue;
            return (T)((Declaration)type.cast(statement));
        }
        return null;
    }

    <T extends Declaration> T findDeclNamed(String name, Class<T> type, Container context) {
        if (context == null && !(context instanceof CompilationUnit)) {
            return null;
        }
        Object decl = null;
        switch (context.eClass().getClassifierID()) {
            case 40: {
                decl = this.findDeclNamed(name, type, ((Block)context).getStatements());
                if (decl != null) break;
                return this.findDeclNamed(name, type, context.getOwner());
            }
            case 41: {
                decl = this.findDeclNamed(name, type, ((StatementGroup)context).getStatements());
                if (decl != null) break;
                return this.findDeclNamed(name, type, context.getOwner());
            }
            case 19: {
                decl = this.findDeclNamed(name, type, ((FunctionDeclaration)context).getArguments());
                if (decl != null) break;
                return this.findDeclNamed(name, type, context.getOwner());
            }
            case 23: {
                decl = this.findDeclNamed(name, type, ((CompilationUnit)context).getDeclarations());
                if (decl != null) break;
                return null;
            }
        }
        if (type.isAssignableFrom(decl.getClass()) && decl.getName().equals(name)) {
            return (T)((Declaration)type.cast(decl));
        }
        return null;
    }

    public Type toJniType(obp.fiacre.model.Type type) {
        return this.toJniType(type, Collections.<obp.fiacre.model.Type, Type>emptyMap());
    }

    public Type toJniType(obp.fiacre.model.Type type, Map<obp.fiacre.model.Type, Type> typeNames) {
        if (type instanceof BoolType) {
            return this.cBuilder.booleanType();
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return this.cBuilder.integerType();
        }
        if (type instanceof TypeId) {
            return this.toJniType(((TypeId)type).getDecl().getIs(), typeNames);
        }
        if (type instanceof Array) {
            this.hasArray = true;
            ExternalType arrayType = this.cBuilder.externalType("jobject");
            return arrayType;
        }
        if (type instanceof Queue) {
            ExternalType arrayType = this.cBuilder.externalType("jobject");
            return arrayType;
        }
        return typeNames.get(type);
    }

    @Override
    public boolean hasArray() {
        return this.hasArray;
    }
}

