/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.io.File;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import obp.cc.ConcreteContext;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.core.ConfComparator;
import obp.explorer.runtime.fiacre.ConcreteContextConfiguration;
import obp.explorer.runtime.fiacre.ConcreteContextEnvFactory;
import obp.explorer.runtime.obs.AtomicAction;

public abstract class ContextDrivenExplorer
extends AbstractExplorer {
    Queue<Configuration> toSee;
    int contextBehaviorId;
    int zappedConfigurations = 0;
    int totalConfigurationCount;
    int currentContextState = 0;

    public ContextDrivenExplorer(ProgramLoader programLoader) {
        this(programLoader, (ConcreteContext)null, (File)null);
    }

    public ContextDrivenExplorer(ProgramLoader programLoader, ConcreteContext context, File ccsl) {
        super(programLoader, context, ccsl, context == null ? null : new ConcreteContextEnvFactory(context));
        if (context == null) {
            throw new RuntimeException("Cannot run a context-driven explorer without a context");
        }
    }

    @Override
    public void initializeExploration() {
        Configuration initial = this.prepareExploration();
        this.contextBehaviorId = this.getProcessBehaviorCount() - 1;
        this.createKnown();
        this.toSee = new PriorityQueue<Configuration>(50, new ConfComparator(this.contextBehaviorId));
        this.zappedConfigurations = 0;
        this.registerNewConfiguration(initial);
        this.behaviorCount = this.getProcessBehaviorCount();
    }

    @Override
    public boolean atEnd() {
        return this.toSee.isEmpty();
    }

    @Override
    public Configuration nextConfiguration() {
        return this.toSee.remove();
    }

    @Override
    protected void onNewConfiguration(Configuration newConfiguration) {
        this.toSee.add(newConfiguration);
        ++this.totalConfigurationCount;
    }

    @Override
    protected void onExistingConfiguration(Configuration configuration) {
    }

    @Override
    protected void onRegisterActionAndTarget(Configuration source, List<AtomicAction> actions2, Configuration target) {
    }

    @Override
    protected void explorationStep() {
        this.checkMemoryLimit(this.minMemory, this.maxMemory, 1000);
        Configuration configuration = this.nextConfiguration();
        int configurationCtxState = this.getContextState(configuration);
        if (this.currentContextState != configurationCtxState) {
            this.onContextChange(this.currentContextState, configurationCtxState);
            this.currentContextState = configurationCtxState;
        }
        this.fireTransitions(configuration);
    }

    protected int getContextState(Configuration conf) {
        return ((ConcreteContextConfiguration)conf.behaviorConfigurations[this.contextBehaviorId]).getState();
    }

    abstract void onContextChange(int var1, int var2);

    @Override
    public long getConfigurationCount() {
        return this.totalConfigurationCount;
    }
}

