/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.buchi;

import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.buchi.BuchiConfiguration;
import obp.explorer.runtime.evaluator.Tester;

public class BuchiTransition {
    public final short behaviorId;
    private final short sourceState;
    private final Tester guardTester;
    private final short targetState;

    public BuchiTransition(short behaviorId, short sourceState, Tester guardTester, short targetState) {
        this.behaviorId = behaviorId;
        this.sourceState = sourceState;
        this.guardTester = guardTester;
        this.targetState = targetState;
    }

    public boolean guard(Configuration source, Configuration target) {
        BuchiConfiguration meSource = (BuchiConfiguration)source.behaviorConfigurations[this.behaviorId];
        if (meSource.state != this.sourceState) {
            return false;
        }
        return this.guardTester.test(target);
    }

    public void action(Configuration configuration) {
        BuchiConfiguration me = (BuchiConfiguration)configuration.behaviorConfigurations[this.behaviorId];
        me.state = this.targetState;
    }

    public String toString() {
        StringBuilder test = new StringBuilder();
        test.append(this.sourceState);
        test.append(" -- ");
        test.append("?TODO:predicate?");
        test.append(" -> ");
        test.append(this.targetState);
        return test.toString();
    }
}

