/*
 * Decompiled with CFR 0.152.
 */
package plug.language.composition;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Map;
import language.compositionLang.model.ExternalProcessDeclaration;
import language.compositionLang.model.InstanceDeclaration;
import language.compositionLang.model.Model;
import language.compositionLang.parser.CompositionLangParser;
import plug.composite.CompositeRuntime;
import plug.core.ILanguageLoader;
import plug.core.ILanguagePlugin;
import plug.core.ITransitionRelation;
import plug.core.registry.LanguageModuleRegistry;

public class CompositionLangLoader
implements ILanguageLoader<CompositeRuntime> {
    public CompositeRuntime getRuntime(URI modelURI, Map<String, Object> options) throws Exception {
        LanguageModuleRegistry registry = LanguageModuleRegistry.getInstance();
        Model model = null;
        try {
            model = CompositionLangParser.parse(modelURI);
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
        CompositeRuntime runtime = new CompositeRuntime();
        for (InstanceDeclaration instance : model.getComposition().getInstances()) {
            ExternalProcessDeclaration process = instance.getProcessDeclaration();
            ILanguagePlugin module = registry.getModuleByName(process.getLanguageID());
            ILanguageLoader loader = module.getLoader();
            ITransitionRelation instanceRuntime = null;
            try {
                String address = process.getAddress();
                instanceRuntime = Paths.get(address, new String[0]).isAbsolute() ? loader.getRuntime(new URI(address)) : loader.getRuntime(modelURI.resolve(address));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            runtime.addRuntime(instance.getName(), instanceRuntime);
            runtime.runtimeToModule.put(instanceRuntime, module);
        }
        return runtime;
    }
}

