/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import obp.fiacre.model.Arg;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.Composition;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Instance;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.Par;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.Variable;
import obp.fiacre.util.ExpressionUtil;
import obp.fiacre.util.StatementUtil;

public class ComponentUtil {
    public static Set<LocalVariable> getReferencedVariables(ComponentDecl component) {
        HashSet<LocalVariable> referenced = new HashSet<LocalVariable>();
        ComponentUtil.findReferencedVariables(component.getBody(), referenced);
        return referenced;
    }

    private static void findReferencedVariables(Composition composition, Set<LocalVariable> referenced) {
        block3: {
            block2: {
                if (!(composition instanceof Par)) break block2;
                for (InterfacedComp child : ((Par)composition).getArgList()) {
                    ComponentUtil.findReferencedVariables(child.getComposition(), referenced);
                }
                break block3;
            }
            if (!(composition instanceof Instance)) break block3;
            for (Arg arg : ((Instance)composition).getArgList()) {
                Variable ref;
                if (!(arg instanceof RefArg) || !((ref = ((RefArg)arg).getRef()) instanceof LocalVariable)) continue;
                referenced.add((LocalVariable)ref);
            }
        }
    }

    public static Set<Variable> getUsedVariables(ComponentDecl component) {
        HashSet<Variable> referenced = new HashSet<Variable>();
        referenced.addAll(StatementUtil.findUsedVariables(component.getInitAction()));
        ComponentUtil.findUsedVariables(component.getBody(), referenced);
        return referenced;
    }

    private static void findUsedVariables(Composition composition, Set<Variable> referenced) {
        block4: {
            block3: {
                if (!(composition instanceof Par)) break block3;
                for (InterfacedComp child : ((Par)composition).getArgList()) {
                    ComponentUtil.findUsedVariables(child.getComposition(), referenced);
                }
                break block4;
            }
            if (!(composition instanceof Instance)) break block4;
            for (Arg arg : ((Instance)composition).getArgList()) {
                if (arg instanceof RefArg) {
                    Variable ref = ((RefArg)arg).getRef();
                    if (!(ref instanceof LocalVariable)) continue;
                    referenced.add((LocalVariable)ref);
                    continue;
                }
                if (!(arg instanceof Exp)) continue;
                referenced.addAll(ExpressionUtil.findUsedVariables((Exp)arg));
            }
        }
    }

    public static List<Instance> getInstances(ComponentDecl componentDecl) {
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        ComponentUtil.collectInstances(componentDecl.getBody(), instanceList);
        return instanceList;
    }

    private static void collectInstances(Composition composition, List<Instance> instanceList) {
        if (composition instanceof Par) {
            for (InterfacedComp interfacedComp : ((Par)composition).getArgList()) {
                ComponentUtil.collectInstances(interfacedComp.getComposition(), instanceList);
            }
        } else if (composition instanceof Instance) {
            instanceList.add((Instance)composition);
        }
    }
}

