/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker;

import obp.fiacre.checker.NodeAnalyzer;
import obp.fiacre.checker.TransitionAnalyzer;
import obp.fiacre.checker.TypeAnalyzer;
import obp.fiacre.checker.VariableAnalyzer;
import obp.fiacre.model.Program;
import org.xid.basics.error.ErrorHandler;

public class ProgramAnalyzer {
    private final ErrorHandler errorHandler;
    private final Program program;
    private final TypeAnalyzer typeChecker;
    private final NodeAnalyzer nodeAnalyzer;
    private final TransitionAnalyzer transitionAnalyzer;
    private final VariableAnalyzer variableAnalyzer;

    public ProgramAnalyzer(ErrorHandler errorHandler, Program program) {
        this.program = program;
        this.errorHandler = errorHandler;
        this.typeChecker = new TypeAnalyzer(this);
        this.nodeAnalyzer = new NodeAnalyzer(this);
        this.transitionAnalyzer = new TransitionAnalyzer(this);
        this.variableAnalyzer = new VariableAnalyzer(this);
    }

    public void analyze() {
        if (!this.typeChecker.analyze()) {
            throw new IllegalArgumentException("Type checking fails.");
        }
        if (!this.nodeAnalyzer.analyze()) {
            throw new IllegalArgumentException("Node analyze fails.");
        }
        if (!this.transitionAnalyzer.analyze()) {
            throw new IllegalArgumentException("Transitions analyze fails.");
        }
        if (!this.variableAnalyzer.analyze()) {
            throw new IllegalArgumentException("Variables analyze fails.");
        }
    }

    public Program getProgram() {
        return this.program;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public TypeAnalyzer getTypeAnalyzer() {
        return this.typeChecker;
    }

    public NodeAnalyzer getProcessAnalyser() {
        return this.nodeAnalyzer;
    }

    public TransitionAnalyzer getTransitionAnalyser() {
        return this.transitionAnalyzer;
    }

    public VariableAnalyzer getVariableAnalyser() {
        return this.variableAnalyzer;
    }
}

