/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.explorer.ConfsFile2MTX;
import obp.explorer.ConfsFileHandler;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.obs.Action;
import obp.util.ConcreteContextUtil;
import org.xid.basics.error.DiagnosticUtil;

public class ConfsIO {
    private Mode mode = Mode.Default;
    private File confsFile;
    private String programClassName;
    private File programPath;
    private InputStream ccStream;
    private File ccslFile;
    private ConfsFileHandler confsFileHandler = null;
    private File matrixMarketFile = null;

    private void usage() {
        this.outln("Usage: ConfsIO [options] -p|--programpath programclass confsfile.");
        this.outln("Mandatory parameters: ");
        this.outln("\t[--programpath or -p] path\tPath to search for Program class.");
        this.outln();
        this.outln("Context parameters:");
        this.outln("\t[--cc or -c] (cc_file|-)\t\tPath to associated concrete context file, '-' for stdin.");
        this.outln();
        this.outln("CCSL parameters:");
        this.outln("\t[--ccsl] (ccsl_file)\t\tPath to associated ccsl file");
        this.outln();
        this.outln("Optional parameters: ");
        this.outln("\t[--summary or -s]\t\tSumarizes results.");
        this.outln("\t[--interactive or -i]\t\tInteractive mode.");
        this.outln("\t[--aut]\t\t\t\tPrints AUT format.");
        this.outln("\t[--matrix-market or -mm] mtx-file\tExtracts the graph in matrix-market format.");
        this.outln("\t[--quiet or -q]\t\t\tNo outputs on stdio.");
        this.outln("\t[--help or -h]\t\t\tPrints this help and exit.");
    }

    private void interactiveUsage() {
        this.outln("Available commands:");
        this.outln("[conf or c] id\t\tShow configuration 'id'.");
        this.outln("[quit or q]\t\tQuit interactive mode.");
        this.outln("[help or h]\t\tShow this help.");
    }

    public boolean readArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("--programpath".equals(args[i]) || "-p".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--programpath' needs an argument.");
                    return false;
                }
                if (args[i].length() == 0 || args[i].startsWith("-")) {
                    System.err.println("Invalid file/path name '" + args[i] + "'.");
                    return false;
                }
                this.programPath = new File(args[i]);
                if (!this.programPath.exists()) {
                    System.err.println("Program path '" + args[i] + "' doesn't exist.");
                    return false;
                }
                if (this.programPath.canRead()) continue;
                System.err.println("Program path '" + args[i] + "' isn't accessible.");
                return false;
            }
            if ("--cc".equals(args[i]) || "-c".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--cc' needs an argument.");
                    return false;
                }
                if (args[i].equals("-")) {
                    this.ccStream = System.in;
                    continue;
                }
                try {
                    this.ccStream = new FileInputStream(args[i]);
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.err.println("Concrete context file '" + args[i] + "' doesn't exist.");
                    return false;
                }
            }
            if ("--ccsl".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--ccsl' needs an argument.");
                    return false;
                }
                if (args[i].length() == 0 || args[i].startsWith("-")) {
                    System.err.println("Invalid file/path name '" + args[i] + "'.");
                    return false;
                }
                this.ccslFile = new File(args[i]);
                if (!this.ccslFile.exists()) {
                    System.err.println("CCSL path '" + args[i] + "' doesn't exist.");
                    return false;
                }
                if (this.ccslFile.canRead()) continue;
                System.err.println("CCSL path '" + args[i] + "' isn't accessible.");
                return false;
            }
            if ("--summary".equals(args[i]) || "-s".equals(args[i])) {
                this.mode = Mode.Summary;
                continue;
            }
            if ("--interactive".equals(args[i]) || "-i".equals(args[i])) {
                this.mode = Mode.Interactive;
                continue;
            }
            if ("--aut".equals(args[i])) {
                this.mode = Mode.Aut;
                continue;
            }
            if ("--matrix-market".equals(args[i]) || "-mm".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '-mm' needs an argument.");
                    return false;
                }
                this.matrixMarketFile = new File(args[i]);
                this.mode = Mode.MatrixMarket;
                continue;
            }
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                this.usage();
                return false;
            }
            if (args[i].startsWith("-")) {
                System.err.println("Unknown option '" + args[i] + "'.");
                this.usage();
                return false;
            }
            if (this.programClassName == null) {
                this.programClassName = args[i];
                continue;
            }
            if (this.confsFile != null) continue;
            this.confsFile = new File(args[i]);
            if (!this.confsFile.exists()) {
                System.err.println("Confs file '" + args[i] + "' doesn't exist.");
                return false;
            }
            if (this.confsFile.canRead()) continue;
            System.err.println("Confs file '" + args[i] + "' isn't accessible.");
            return false;
        }
        if (this.programClassName == null) {
            System.err.println("Program class is missing.");
            this.usage();
            return false;
        }
        if (this.programPath == null) {
            System.err.println("Program path is missing (option -p).");
            this.usage();
            return false;
        }
        if (this.confsFile == null) {
            System.err.println("Confs file is missing (option -i).");
            this.usage();
            return false;
        }
        return true;
    }

    public void read() throws Exception {
        try {
            ConcreteContext cc;
            ProgramLoader.FromClass loader = new ProgramLoader.FromClass(this.programClassName, this.programPath);
            ConcreteContext concreteContext = cc = this.ccStream == null ? null : ConcreteContextUtil.loadCC(this.ccStream);
            if (this.mode == Mode.MatrixMarket) {
                this.confsFileHandler = new ConfsFile2MTX(loader, cc, this.ccslFile, this.confsFile);
                this.matrixMarketMode();
            } else {
                this.confsFileHandler = new ConfsFileHandler(loader, cc, this.ccslFile, this.confsFile);
                if (this.mode == Mode.Interactive) {
                    this.interactiveMode();
                } else if (this.mode == Mode.Aut) {
                    this.autMode();
                } else {
                    while (this.confsFileHandler.readOnce()) {
                        if (this.mode != Mode.Default) continue;
                        this.outConfigurationAndActions(this.confsFileHandler.getLastReadConfiguration(), this.confsFileHandler.getLastReadActions());
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't read confs file '" + this.confsFile.getPath() + "'.");
            return;
        }
        finally {
            if (this.confsFileHandler != null) {
                this.confsFileHandler.close();
            }
        }
        if (this.mode == Mode.Summary) {
            this.outln("Read configurations " + this.confsFileHandler.getConfigurationCount() + " and " + this.confsFileHandler.getActionCount() + " actions.");
        }
    }

    private void interactiveMode() throws Exception {
        this.outln("Entering interactive mode (type 'help' for help).");
        this.outConfigurationAndActions(this.confsFileHandler.getConfiguration(0), this.confsFileHandler.getActionsFrom(0));
        this.out("> ");
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
        String line = inReader.readLine();
        while (line != null) {
            String[] cmdArray = line.trim().split(" ");
            if (cmdArray.length > 0) {
                if ("quit".equals(cmdArray[0]) || "q".equals(cmdArray[0])) break;
                if ("help".equals(cmdArray[0]) || "h".equals(cmdArray[0])) {
                    this.interactiveUsage();
                } else if ("conf".equals(cmdArray[0]) || "c".equals(cmdArray[0])) {
                    if (cmdArray.length > 1) {
                        for (int i = 1; i < cmdArray.length; ++i) {
                            try {
                                int confId = Integer.parseInt(cmdArray[1]);
                                Configuration configuration = this.confsFileHandler.getConfiguration(confId);
                                if (configuration != null) {
                                    this.outConfigurationAndActions(configuration, this.confsFileHandler.getActionsFrom(confId));
                                    continue;
                                }
                                this.outln("Invalid configuration id '" + cmdArray[1] + "'.");
                                continue;
                            }
                            catch (NumberFormatException e) {
                                this.outln("Invalid configuration id '" + cmdArray[1] + "'.");
                            }
                        }
                    } else {
                        this.outln("Invalid 'conf' command needs arguments.");
                    }
                } else {
                    this.outln("Invalid command '" + line + "', try 'help'.");
                }
            }
            this.out("> ");
            line = inReader.readLine();
        }
    }

    private void autMode() {
        this.confsFileHandler.readAll();
        this.outln(this.confsFileHandler.toAut());
    }

    private void matrixMarketMode() {
        this.matrixMarketFile.getAbsoluteFile().getParentFile().mkdirs();
        try {
            this.matrixMarketFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.confsFileHandler.toMatrixMarket(this.matrixMarketFile);
    }

    public void outConfigurationAndActions(Configuration configuration, List<Action> localActions) {
        this.outln("- " + this.confsFileHandler.configurationToString(configuration));
        for (Action action : localActions) {
            this.outln("-- " + this.confsFileHandler.actionToString(action) + " -> " + action.targetId);
        }
    }

    public void out(String message) {
        System.out.print(message);
    }

    public void outln(String message) {
        System.out.println(message);
    }

    public void outln() {
        System.out.println();
    }

    public static boolean read(String[] args) {
        ConfsIO main = new ConfsIO();
        boolean result = false;
        try {
            if (main.readArguments(args)) {
                main.read();
                result = true;
            }
        }
        catch (Exception e) {
            System.err.println(DiagnosticUtil.createMessage((Throwable)e));
        }
        return result;
    }

    public static void main(String[] args) {
        ConfsIO.read(args);
    }

    private static enum Mode {
        Default,
        Summary,
        Interactive,
        Aut,
        MatrixMarket;

    }
}

