/*
 * Decompiled with CFR 0.152.
 */
package spinja.util;

public final class StringWriter {
    private final String prefix;
    private final String postfix;
    private char[] buffer;
    private int used;
    private int indented;
    private int savePoint;

    public StringWriter() {
        this(32);
        this.savePoint = 0;
    }

    public StringWriter(int n) {
        this("\t", System.getProperty("line.separator"), n);
    }

    public StringWriter(String string, String string2, int n) {
        this.prefix = string;
        this.postfix = string2;
        this.buffer = new char[n];
        this.used = 0;
        this.indented = 0;
    }

    public StringWriter append(Object object) {
        String string = String.valueOf(object);
        int n = string.length();
        this.expand(this.used + n);
        string.getChars(0, n, this.buffer, this.used);
        this.used += n;
        return this;
    }

    public StringWriter appendIf(boolean bl, Object object) {
        if (bl) {
            this.append(object);
        }
        return this;
    }

    public StringWriter appendLine(Object ... objectArray) {
        if (objectArray.length > 0) {
            this.appendPrefix();
        }
        for (Object object : objectArray) {
            this.append(object);
        }
        this.appendPostfix();
        return this;
    }

    public StringWriter appendPostfix() {
        this.append(this.postfix);
        return this;
    }

    public StringWriter appendPrefix() {
        for (int i = 0; i < this.indented; ++i) {
            this.append(this.prefix);
        }
        return this;
    }

    public char charAt(int n) {
        if (n >= this.used || n < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[n];
    }

    public void clear() {
        this.used = 0;
    }

    public boolean equals(Object object) {
        if (object.getClass() == StringWriter.class) {
            StringWriter stringWriter = (StringWriter)object;
            if (this.used == stringWriter.used) {
                for (int i = 0; i < this.used; ++i) {
                    if (this.buffer[i] == stringWriter.buffer[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private final void expand(int n) {
        if (n > this.buffer.length) {
            int n2;
            for (n2 = this.buffer.length * 2; n2 < n; n2 *= 2) {
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
            this.buffer = cArray;
        }
    }

    public int getIndentLevel() {
        return this.indented;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public StringWriter indent() {
        if (this.indented < Integer.MAX_VALUE) {
            ++this.indented;
        }
        return this;
    }

    public int length() {
        return this.used;
    }

    public StringWriter outdent() {
        if (this.indented > 0) {
            --this.indented;
        }
        return this;
    }

    public StringWriter removePostfix() {
        this.used -= this.postfix.length();
        return this;
    }

    public void revertToSavePoint() {
        this.used = this.savePoint;
    }

    public void setLength(int n) {
        if (n > this.used) {
            this.expand(n);
            for (int i = this.used; i < n; ++i) {
                this.buffer[i] = 32;
            }
        }
        this.used = n;
    }

    public void setSavePoint() {
        this.savePoint = this.used;
    }

    public String toString() {
        return new String(this.buffer, 0, this.used);
    }

    public String getPostfix() {
        return this.postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

