/*
 * Decompiled with CFR 0.152.
 */
package obp.literal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.literal.Literal;
import obp.literal.LiteralField;
import obp.literal.LiteralVisitor;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class RecordLiteral
extends Literal
implements BoostObject {
    private final List<LiteralField> fieldList = new ArrayList<LiteralField>();
    private String typeName;

    public RecordLiteral() {
    }

    protected RecordLiteral(Boost boost) {
        super(boost);
        for (LiteralField oneChild : BoostUtil.readObjectList((Boost)boost, LiteralField.class)) {
            this.fieldList.add(oneChild);
        }
        this.typeName = boost.readString();
    }

    public List<LiteralField> getFieldList() {
        return Collections.unmodifiableList(this.fieldList);
    }

    public int getFieldCount() {
        return this.fieldList.size();
    }

    public LiteralField getField(int index) {
        if (index < 0 || index >= this.getFieldCount()) {
            return null;
        }
        return this.fieldList.get(index);
    }

    public void addField(LiteralField newValue) {
        this.addField(this.getFieldCount(), newValue);
    }

    public void addField(int index, LiteralField newValue) {
        this.fieldList.add(index, newValue);
    }

    public LiteralField setField(int index, LiteralField newValue) {
        return this.fieldList.set(index, newValue);
    }

    public void addAllField(Collection<LiteralField> toAddList) {
        for (LiteralField newValue : toAddList) {
            this.addField(this.getFieldCount(), newValue);
        }
    }

    public void removeField(LiteralField value) {
        int index = this.fieldList.indexOf(value);
        if (index >= 0) {
            this.removeField(index);
        }
    }

    public void removeField(int index) {
        this.fieldList.remove(index);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String newValue) {
        if (this.typeName == null ? newValue != null : !this.typeName.equals(newValue)) {
            this.typeName = newValue;
        }
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.fieldList);
        boost.writeString(this.typeName);
    }

    @Override
    public void accept(LiteralVisitor visitor) {
        visitor.visitRecordLiteral(this);
    }
}

