/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import obp.explorer.MemoryUtil;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.core.BFSExplorer;
import org.xid.basics.Basics;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;

public class ExplorerConfiguration
implements BoostObject {
    private static final String defaultMemoryValue = "2g";
    public static final Pattern percentagePattern = Pattern.compile("([0-9]+)%");
    public static final Pattern heapOptionPattern = Pattern.compile("([0-9]+)(m|g|M|G)");
    private String memoryLimit;
    private boolean isContextDirected;
    private Class<? extends AbstractExplorer> explorerClass = BFSExplorer.class;
    public boolean checkDBMInclusion = true;

    public ExplorerConfiguration() {
        if (Basics.isWindows()) {
            this.setMemoryLimit("1500m");
        }
        this.isContextDirected = false;
    }

    public ExplorerConfiguration(Boost boost) {
        boost.register((BoostObject)this);
        this.memoryLimit = boost.readString();
        this.isContextDirected = boost.readBoolean();
    }

    public Class<? extends AbstractExplorer> getExplorerClass() {
        return this.explorerClass;
    }

    public void setExplorerClass(Class<? extends AbstractExplorer> explorerClass) {
        this.explorerClass = explorerClass;
    }

    public boolean isContextDirected() {
        return this.isContextDirected;
    }

    public void setContextDirected(boolean isCD) {
        this.isContextDirected = isCD;
    }

    public String getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(String memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public void writeToBoost(Boost boost) {
        boost.writeString(this.memoryLimit);
        boost.writeBoolean(this.isContextDirected);
    }

    public String getVMHeapOption() {
        String localMemoryLimit = this.memoryLimit == null ? "100%" : this.memoryLimit;
        Matcher percentageMatcher = percentagePattern.matcher(localMemoryLimit);
        if (percentageMatcher.matches()) {
            long available = MemoryUtil.getTotalPhysicalMemorySize();
            if (available < 0L) {
                System.err.println("[Warning] Cannot detect available memory for computer, using '2g'. Check memory limit option.");
                return defaultMemoryValue;
            }
            int percentage = Integer.parseInt(percentageMatcher.group(1));
            int heapSize = (int)(available /= 0x100000L) * percentage / 100;
            return heapSize + "m";
        }
        return localMemoryLimit;
    }
}

