/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import spinja.exceptions.SpinJaException;
import spinja.model.Model;
import spinja.model.Transition;
import spinja.search.Algoritm;
import spinja.search.Message;
import spinja.search.SearchableStack;
import spinja.search.TransitionCalculator;
import spinja.store.StateStore;
import spinja.store.hash.HashAlgorithm;
import spinja.util.ByteArrayStorage;

public abstract class SearchAlgorithm<M extends Model<T>, T extends Transition>
extends Algoritm
implements NotificationListener,
NotificationFilter {
    private static final long serialVersionUID = -9221923281786933752L;
    protected final M model;
    protected final StateStore store;
    protected final boolean checkForDeadlocks;
    protected final int maxErrors;
    protected int nrErrors;
    protected int atomicSteps;
    protected int statesMatched;
    protected volatile boolean outOfMemory;
    protected int maxSize;
    protected int maxDepth;
    protected final boolean errorExceedDepth;
    private boolean printedDepthWarning;
    private long lastStates = 0L;
    private HashAlgorithm hash;
    protected final TransitionCalculator<M, T> nextTransition;
    protected final ByteArrayStorage storage = new ByteArrayStorage();

    public SearchAlgorithm(M m, StateStore stateStore, boolean bl, int n, boolean bl2, TransitionCalculator<M, T> transitionCalculator) {
        this.model = m;
        this.store = stateStore;
        this.checkForDeadlocks = bl;
        this.maxErrors = n == 0 ? Integer.MAX_VALUE : n;
        this.errorExceedDepth = bl2;
        this.nextTransition = transitionCalculator;
        this.printedDepthWarning = false;
        this.nrErrors = 0;
        this.maxSize = 0;
        this.hash = HashAlgorithm.getDefaultAlgorithm();
        ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this, this, null);
    }

    protected abstract boolean addState(byte[] var1, int var2);

    protected abstract boolean checkModelState();

    public int getAtomicSteps() {
        return this.atomicSteps;
    }

    @Override
    public long getBytes() {
        return 26L + this.store.getBytes();
    }

    public abstract int getDepth();

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getNrErrors() {
        return this.nrErrors;
    }

    @Override
    public long getNrStates() {
        return this.store.getStored();
    }

    public int getStatesMatched() {
        return this.statesMatched;
    }

    @Override
    public void handleNotification(Notification notification, Object object) {
        this.printInfo();
        if (this.lastStates + (this.lastStates >> 7) >= (long)this.store.getStored()) {
            this.outOfMemory = true;
        }
        this.lastStates = this.store.getStored();
    }

    protected abstract T getLastTransition();

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        return notification.getType() == "java.management.memory.collection.threshold.exceeded";
    }

    protected abstract Transition nextTransition();

    protected abstract void outputTrace(String var1);

    protected boolean print(String string) {
        System.out.println(string);
        return true;
    }

    public void printInfo() {
        double d = (double)this.getBytes() / 1048576.0;
        System.out.printf("Depth= %7d States= %4.3e Transitions= %4.3e Memory= %-6.3f Errors= %7d\n", this.maxDepth, (double)this.store.getStored(), (double)this.store.getStored() + (double)this.statesMatched, d, this.nrErrors);
    }

    @Override
    public void printSummary() {
        System.out.println("");
        System.out.println("State-vector " + this.maxSize + " byte, depth reached " + this.maxDepth + ", errors: " + this.nrErrors);
        System.out.printf("%8d states, stored\n", this.store.getStored());
        System.out.printf("%8d states, matched\n", this.statesMatched);
        System.out.printf("%8d transitions (= stored+matched)\n", this.store.getStored() + this.statesMatched);
        System.out.printf("%8d atomic steps\n", this.atomicSteps);
        this.store.printSummary();
    }

    protected void report(Message message) {
        this.report(message, message.getDefaultMessage());
    }

    protected final void report(Message message, String string) {
        if (message.isError()) {
            if (this.nrErrors < 1) {
                System.out.println("spinja error: " + string + " (at depth " + this.getDepth() + ")");
                if (this.maxErrors == 1) {
                    this.outputTrace(((Model)this.model).getName());
                }
            }
            ++this.nrErrors;
        } else if (message.isWarning()) {
            System.out.println("spinja warning: " + string + " (at depth " + this.getDepth() + ")");
        } else assert (this.print("  " + string));
    }

    protected abstract boolean restoreState();

    @Override
    public void execute() {
        int n;
        byte[] byArray = this.storeModel();
        if (((Model)this.model).conditionHolds(4)) {
            n = this.store.addState(byArray);
            if (n >= 0) assert (this.print("  New state " + (this.store.getStored() - 1)));
        } else {
            n = this.hash.hash(byArray, 0);
            ++this.atomicSteps;
        }
        if (!this.addState(byArray, n)) {
            throw new RuntimeException("Could not even add the first state.");
        }
        while (this.nrErrors < this.maxErrors && !Thread.currentThread().isInterrupted() && this.restoreState()) {
            if (this.outOfMemory) {
                throw new OutOfMemoryError();
            }
            assert (this.checkModelState());
            Transition transition = this.nextTransition();
            if (transition == null) {
                if (this.checkForDeadlocks && !((Model)this.model).conditionHolds(1) && this.getLastTransition() == null) {
                    this.report(Message.DEADLOCK);
                } else {
                    this.report(Message.NO_MORE_TRANSITIONS);
                }
                this.stateDone();
                continue;
            }
            try {
                this.takeTransition(transition);
            }
            catch (SpinJaException spinJaException) {
                this.report(Message.TRANS_ERROR, spinJaException.getMessage());
                continue;
            }
            byArray = this.storeModel();
            if (((Model)this.model).conditionHolds(4)) {
                n = this.store.addState(byArray);
                if (n < 0) {
                    this.report(Message.DUPLICATE_STATE.withState(byArray));
                    this.nextTransition.duplicateState(this.model, this.getLastTransition(), byArray, -(n + 1), this.getSearchableStack());
                    ++this.statesMatched;
                    this.undoTransition();
                    continue;
                }
                if ((this.store.getStored() & 0xFFFFF) == 0) {
                    this.printInfo();
                }
                assert (this.print("  New state " + (this.store.getStored() - 1)));
                assert (this.print(Arrays.toString(byArray)));
                assert (this.print(((Model)this.model).toString()));
            } else {
                ++this.atomicSteps;
                n = this.hash.hash(byArray, 0);
            }
            if (!this.addState(byArray, n)) {
                if (this.errorExceedDepth) {
                    this.report(Message.EXCEED_DEPTH_ERROR);
                } else if (!this.printedDepthWarning) {
                    this.report(Message.EXCEED_DEPTH_WARNING);
                    this.printedDepthWarning = true;
                }
                this.undoTransition();
                continue;
            }
            if (byArray.length > this.maxSize) {
                this.maxSize = byArray.length;
            }
            if (this.getDepth() - 1 <= this.maxDepth) continue;
            this.maxDepth = this.getDepth() - 1;
        }
        this.freeMemory();
    }

    protected abstract void stateDone();

    protected byte[] storeModel() {
        this.storage.init(this.model.getSize());
        this.model.encode(this.storage);
        return this.storage.getBuffer();
    }

    protected abstract void takeTransition(Transition var1) throws SpinJaException;

    protected abstract void undoTransition();

    public abstract SearchableStack getSearchableStack();
}

