/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.model;

import spinja.exceptions.ValidationException;
import spinja.promela.model.PromelaModel;
import spinja.promela.model.PromelaProcess;
import spinja.promela.model.PromelaTransition;
import spinja.promela.model.PromelaTransitionFactory;

public class RendezvousTransition
extends PromelaTransition {
    final PromelaTransition send;
    final PromelaTransition read;
    final PromelaModel model;

    public RendezvousTransition(PromelaModel promelaModel, PromelaTransition promelaTransition, PromelaTransition promelaTransition2) {
        this.model = promelaModel;
        this.send = promelaTransition;
        this.read = promelaTransition2;
    }

    @Override
    public int getId() {
        return this.send.getId() << 16 | this.read.getId();
    }

    public RendezvousTransition nextRendezvousTransition() {
        PromelaProcess promelaProcess = this.read.getProcess();
        PromelaTransitionFactory promelaTransitionFactory = this.read.getFactory().getNext();
        int[] nArray = this.send.getFactory().getRendezvous();
        while (true) {
            if (promelaTransitionFactory == null) {
                if ((promelaProcess = promelaProcess.prevProcess()) == this.send.getProcess()) continue;
                if (promelaProcess == null) break;
                promelaTransitionFactory = promelaProcess.getCurrentState().getFirst();
                continue;
            }
            if (promelaTransitionFactory.canReadRendezvous(nArray)) {
                return new RendezvousTransition(this.model, this.send, promelaTransitionFactory.newTransition());
            }
            promelaTransitionFactory = promelaTransitionFactory.getNext();
        }
        return null;
    }

    @Override
    public PromelaProcess getProcess() {
        return this.send.getProcess();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void take() throws ValidationException {
        this.model.activateTransitionListener(false);
        this.send.take();
        this.read.take();
        this.model.activateTransitionListener(true);
        this.model.sendTransitionTakenEvent(this);
    }

    public String toString() {
        return this.send.toString() + " rendez-vous with " + this.read.toString();
    }

    @Override
    public void undo() {
        this.model.activateTransitionListener(false);
        this.read.undo();
        this.send.undo();
        this.model.activateTransitionListener(true);
        this.model.sendTransitionUndoEvent(this);
    }

    @Override
    public PromelaTransitionFactory getFactory() {
        return this.send.getFactory();
    }
}

