/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.actions.ChannelSendAction;
import spinja.promela.compiler.actions.Sequence;
import spinja.promela.compiler.expression.Identifier;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.util.StringWriter;

public class OptionAction
extends Action {
    private final boolean loops;
    private final List<Sequence> options;

    public OptionAction(Token token, boolean bl) {
        super(token);
        this.loops = bl;
        this.options = new ArrayList<Sequence>();
    }

    @Override
    public String getEnabledExpression() throws ParseException {
        return null;
    }

    public Sequence startNewOption() {
        Sequence sequence = new Sequence();
        this.options.add(sequence);
        return sequence;
    }

    @Override
    public void printTakeStatement(StringWriter stringWriter) throws ParseException {
        if (this.loops) {
            stringWriter.appendLine("while(true) {").indent();
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Sequence sequence : this.options) {
            String string = sequence.getEnabledExpression();
            if (sequence.startsWithElse() || string == null || string.equals("true")) {
                if (bl) {
                    stringWriter.outdent().appendLine("} else {").indent();
                }
                sequence.printTakeStatement(stringWriter, false);
                bl2 = true;
                break;
            }
            if (!bl) {
                stringWriter.appendLine("if(", string, ") {").indent();
                bl = true;
            } else {
                stringWriter.outdent().appendLine("} else if(", string, ") {").indent();
            }
            sequence.printTakeStatement(stringWriter, false);
        }
        if (bl) {
            if (!bl2 && this.loops) {
                stringWriter.outdent().appendLine("} else {").indent();
                stringWriter.appendLine("break;");
            }
            stringWriter.outdent().appendLine("}");
        }
        if (this.loops) {
            stringWriter.outdent().appendLine("}");
        }
    }

    @Override
    public boolean isLocal(Proctype proctype) {
        for (Sequence sequence : this.options) {
            if (sequence.isLocal(proctype)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void printUndoStatement(StringWriter stringWriter) throws ParseException {
    }

    @Override
    public Collection<Identifier> getChangedVariables() {
        HashSet<Identifier> hashSet = new HashSet<Identifier>();
        for (Sequence sequence : this.options) {
            hashSet.addAll(sequence.getChangedVariables());
        }
        return hashSet;
    }

    @Override
    public boolean isComplex() {
        for (Sequence sequence : this.options) {
            for (Identifier identifier : sequence.getChangedVariables()) {
                if (identifier.getVariable().getArraySize() <= 1) continue;
                return true;
            }
            for (Action action : sequence) {
                if (!(action instanceof ChannelSendAction)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "d_step";
    }
}

