/*
 * Decompiled with CFR 0.152.
 */
package tuml.interpreter.parsercombinator;

import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import tuml.interpreter.parsercombinator.ABCDExpressionLanguage;
import tuml.interpreter.parsercombinator.GrammarLanguage;

public class ParserCombinator {
    private static final String km3Grammar = "\r\n\t\tmetamodel := package*# {Metamodel(packages)};\r\n\t\tpackage := \"package\"! ident \"{\"! classifier*# \"}\"! {Package(name,classifiers)};\r\n\t\tclassifier := class | dataType;\r\n\t\tclass := \"class\"! ident (\"extends\"! ident)?# \"{\"! structuralFeature*# \"}\"! {Class(name,supertype,structuralFeatures)};\r\n\t\tstructuralFeature := attribute | reference;\r\n\t\tattribute := \"attribute\"! ident multiplicity \":\"! ident \";\"! {Attribute(name,multiplicity,typeName)};\r\n\t\treference := \"reference\"! ident multiplicity \"container\"?# \":\"! ident (\"oppositeOf\"! ident)?# \";\"! {Reference(name,multiplicity,isContainer,typeName,opposite)};\r\n\t\tmultiplicity := (\"[\"! (\"*\"! {AnyNumber()} | int \"-\"! int {Bounded(lower, upper)}) \"]\"!)?# \"ordered\"?# \"unique\"?# {Multiplicity(number,isOrdered,isUnique)};\r\n\t\tdataType := \"dataType\"! ident \";\"! {DataType(name)};\r\n\t\tint := /([0-9]+)/;\r\n\t\tident := /([A-Za-z_]\\w*)/;\r\n\t";
    private static final List<Object> nil_ = new Nil<Object>();

    public static void main(String[] args) {
        ParserCombinator.simpleTests();
        ParserCombinator.testGrammars();
        ParserCombinator.testABCDExpression();
    }

    public static void testGrammar(String grammar, String ... programs) {
        Parser<GrammarLanguage.Grammar> parser = GrammarLanguage.getParser();
        Object _testParser = ParserCombinator.testParser(parser, grammar);
        GrammarLanguage.Grammar parsed = (GrammarLanguage.Grammar)_testParser;
        final WrappingParser<Object> parsedParser = parsed.eval();
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String program) {
                ParserCombinator.testParser(parsedParser, program);
            }
        };
        ((java.util.List)Conversions.doWrapArray((Object)programs)).forEach(_function);
    }

    public static void testGrammars() {
        ParserCombinator.testSimpleGrammars();
        ParserCombinator.testKM3Grammar();
        ParserCombinator.testMetaGrammar();
    }

    public static void testSimpleGrammars() {
        ParserCombinator.testGrammar("a := \"A\";", "A");
        ParserCombinator.testGrammar("a := \"A\" | \"B\";", "A", "B");
        ParserCombinator.testGrammar("a := \"A\" \"B\";", "AB", "A B");
        ParserCombinator.testGrammar("a := \"A\" \"B\" | c; c := \"C\";", "AB", "C");
        ParserCombinator.testGrammar("a := \"a\"*#,(\",\"!);", "a,a,a,a,");
        try {
            ParserCombinator.testGrammar("a := \"a\"?#;", "aa");
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace(System.out);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        try {
            ParserCombinator.testGrammar("a := \"a\"+#;", "");
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof Exception) {
                Exception e_1 = (Exception)_t_1;
                e_1.printStackTrace(System.out);
            }
            throw Exceptions.sneakyThrow((Throwable)_t_1);
        }
    }

    public static void testKM3Grammar() {
        ParserCombinator.testGrammar(km3Grammar, "\r\n\t\t\t\tpackage KM3 {\t-- test\r\n\t\t\t\t\tclass ModelElement {\r\n\t\t\t\t\t\tattribute name : String;\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t\tclass Package extends ModelElement {\r\n\t\t\t\t\t\treference classifiers[*] ordered container : Classifier;\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t\tclass Classifier extends ModelElement {}\r\n\r\n\t\t\t\t\tclass Class extends Classifier {\r\n\t\t\t\t\t\treference supertype[0-1] : Class;\r\n\t\t\t\t\t\treference structuralFeatures[*] ordered container : StructuralFeature oppositeOf owner;\r\n\t\t\t\t\t}\r\n\t\r\n\t\t\t\t\tclass StructuralFeature extends ModelElement {\r\n\t\t\t\t\t\treference owner : Class oppositeOf structuralFeatures;\r\n\r\n\t\t\t\t\t\tattribute lower : Integer;\r\n\t\t\t\t\t\tattribute upper : Integer;\r\n\t\t\t\t\t\tattribute isOrdered : Boolean;\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t\tclass Attribute extends StructuralFeature {}\r\n\r\n\t\t\t\t\tclass Reference extends StructuralFeature {\r\n\t\t\t\t\t\tattribute isContainer : Boolean;\r\n\t\t\t\t\t\treference opposite : Reference;\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t\tclass DataType extends Classifier {}\r\n\t\t\t\t}\r\n\r\n\t\t\t\tpackage PrimitiveTypes {\r\n\t\t\t\t\tdataType Boolean;\r\n\t\t\t\t\tdataType Integer;\r\n\t\t\t\t\tdataType String;\r\n\t\t\t\t}\r\n\t\t\t", "\r\n\t\t\t\tpackage A {\t-- test\r\n\t\t\t\t\tclass B {\r\n\t\t\t\t\t\tattribute name orderedunique : String;\r\n\t\t\t\t\t}\r\n\t\t\t\t}\r\n\t\t\t");
    }

    public static void testMetaGrammar() {
        String metaGrammar = "\r\n\t\t\tgrammar := productionRule*;\r\n\t\t\tproductionRule := ident \":=\"! expression \";\"! {ProductionRule(name,body)};\r\n\t\t\texpression := priority3;\r\n\t\t\tpriority3 := priority2 (\"|\"! priority2 {Alternative(left, right)})*;\r\n\t\t\tpriority2 := priority1 (\"{\"! ident \"(\"! ident*#,(\",\"!) \")\"! \"}\"! {Creation(wrapped,typeName,argNames)})?;\r\n\t\t\tpriority1 := priority0 (priority0 {Sequence(left,right)})*;\r\n\t\t\tpriority0 := primitiveExp (\"*\" | \"+\" | \"?\") \"#\"?# (\",\"! primitiveExp)?# {Repetition(wrapped,op,asSet,separator)} | primitiveExp \"!\"! {Drop(wrapped)} | primitiveExp;\r\n\t\t\tprimitiveExp := ident | terminal | regex | \"(\"! expression \")\"!;\r\n\t\t\tident := /([A-Za-z_]\\w*)/;\r\n\t\t\tterminal := /\"([^\"]*)\"/;\r\n\t\t\tregex := /\\/((?:[^\\/\\\\]|\\\\.)*)\\//;\r\n\t\t";
        ParserCombinator.testGrammar("\r\n\t\t\tgrammar := productionRule*;\r\n\t\t\tproductionRule := ident \":=\"! expression \";\"! {ProductionRule(name,body)};\r\n\t\t\texpression := priority3;\r\n\t\t\tpriority3 := priority2 (\"|\"! priority2 {Alternative(left, right)})*;\r\n\t\t\tpriority2 := priority1 (\"{\"! ident \"(\"! ident*#,(\",\"!) \")\"! \"}\"! {Creation(wrapped,typeName,argNames)})?;\r\n\t\t\tpriority1 := priority0 (priority0 {Sequence(left,right)})*;\r\n\t\t\tpriority0 := primitiveExp (\"*\" | \"+\" | \"?\") \"#\"?# (\",\"! primitiveExp)?# {Repetition(wrapped,op,asSet,separator)} | primitiveExp \"!\"! {Drop(wrapped)} | primitiveExp;\r\n\t\t\tprimitiveExp := ident | terminal | regex | \"(\"! expression \")\"!;\r\n\t\t\tident := /([A-Za-z_]\\w*)/;\r\n\t\t\tterminal := /\"([^\"]*)\"/;\r\n\t\t\tregex := /\\/((?:[^\\/\\\\]|\\\\.)*)\\//;\r\n\t\t", "a := A;", km3Grammar, "\r\n\t\t\tgrammar := productionRule*;\r\n\t\t\tproductionRule := ident \":=\"! expression \";\"! {ProductionRule(name,body)};\r\n\t\t\texpression := priority3;\r\n\t\t\tpriority3 := priority2 (\"|\"! priority2 {Alternative(left, right)})*;\r\n\t\t\tpriority2 := priority1 (\"{\"! ident \"(\"! ident*#,(\",\"!) \")\"! \"}\"! {Creation(wrapped,typeName,argNames)})?;\r\n\t\t\tpriority1 := priority0 (priority0 {Sequence(left,right)})*;\r\n\t\t\tpriority0 := primitiveExp (\"*\" | \"+\" | \"?\") \"#\"?# (\",\"! primitiveExp)?# {Repetition(wrapped,op,asSet,separator)} | primitiveExp \"!\"! {Drop(wrapped)} | primitiveExp;\r\n\t\t\tprimitiveExp := ident | terminal | regex | \"(\"! expression \")\"!;\r\n\t\t\tident := /([A-Za-z_]\\w*)/;\r\n\t\t\tterminal := /\"([^\"]*)\"/;\r\n\t\t\tregex := /\\/((?:[^\\/\\\\]|\\\\.)*)\\//;\r\n\t\t");
    }

    public static Object simpleTests() {
        Object _xblockexpression = null;
        try {
            Parser<Object> _symb = ParserCombinator.symb("a");
            ParserCombinator.testParser(_symb, "ab");
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace(System.out);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        Parser<Object> _symb_1 = ParserCombinator.symb("a");
        Parser<Object> _symb_2 = ParserCombinator.symb("b");
        Parser<Object> _then = _symb_1.then(_symb_2);
        ParserCombinator.testParser(_then, "ab");
        Parser<Object> _symb_3 = ParserCombinator.symb("a");
        Parser<Object> _symb_4 = ParserCombinator.symb("b");
        Parser<Object> _or = _symb_3.or(_symb_4);
        ParserCombinator.testParser(_or, "a");
        Parser<Object> _symb_5 = ParserCombinator.symb("a");
        Parser<Object> _symb_6 = ParserCombinator.symb("b");
        Parser<Object> _or_1 = _symb_5.or(_symb_6);
        ParserCombinator.testParser(_or_1, "b");
        try {
            Parser<Object> _symb_7 = ParserCombinator.symb("a");
            Parser<Object> _symb_8 = ParserCombinator.symb("b");
            Parser<Object> _or_2 = _symb_7.or(_symb_8);
            ParserCombinator.testParser(_or_2, "c");
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof Exception) {
                Exception e_1 = (Exception)_t_1;
                e_1.printStackTrace(System.out);
            }
            throw Exceptions.sneakyThrow((Throwable)_t_1);
        }
        try {
            Parser<Object> _symb_9 = ParserCombinator.symb("a");
            Parser<Object> _symb_10 = ParserCombinator.symb("b");
            Parser<Object> _or_3 = _symb_9.or(_symb_10);
            Parser<Object> _mult = _or_3.mult(0, -1);
            ParserCombinator.testParser(_mult, "abc");
        }
        catch (Throwable _t_2) {
            if (_t_2 instanceof Exception) {
                Exception e_2 = (Exception)_t_2;
                e_2.printStackTrace(System.out);
            }
            throw Exceptions.sneakyThrow((Throwable)_t_2);
        }
        Parser<Object> _symb_11 = ParserCombinator.symb("a");
        Parser<Object> _symb_12 = ParserCombinator.symb("b");
        Parser<Object> _or_4 = _symb_11.or(_symb_12);
        Parser<Object> _mult_1 = _or_4.mult(0, -1);
        Parser<Object> _symb_13 = ParserCombinator.symb("c");
        Parser<Object> _then_1 = _mult_1.then(_symb_13);
        _xblockexpression = ParserCombinator.testParser(_then_1, "abc");
        return _xblockexpression;
    }

    public static Object testABCDExpression() {
        Object _xblockexpression = null;
        Object _parser = ABCDExpressionLanguage.getParser();
        Parser parser = (Parser)_parser;
        ParserCombinator.testParser(parser, "true");
        ParserCombinator.testParser(parser, "a");
        ParserCombinator.testParser(parser, "not a");
        ParserCombinator.testParser(parser, "true and false");
        ParserCombinator.testParser(parser, "true and a");
        ParserCombinator.testParser(parser, "a and a");
        ParserCombinator.testParser(parser, "a or b");
        ParserCombinator.testParser(parser, "not (a or b)");
        try {
            ParserCombinator.testParser(parser, "not (a or and b)");
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace(System.out);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        ParserCombinator.testParser(parser, "trueanda");
        ParserCombinator.testParser(parser, "nota");
        try {
            ParserCombinator.testParser(parser, "a andb");
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof Exception) {
                Exception e_1 = (Exception)_t_1;
                e_1.printStackTrace(System.out);
            }
            throw Exceptions.sneakyThrow((Throwable)_t_1);
        }
        Object _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = ParserCombinator.testParser(parser, "a orb");
        }
        catch (Throwable _t_2) {
            if (_t_2 instanceof Exception) {
                Exception e_2 = (Exception)_t_2;
                e_2.printStackTrace(System.out);
            }
            throw Exceptions.sneakyThrow((Throwable)_t_2);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    public static Object testParser(Parser<?> parser, String program) {
        Object _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Parsing: ");
        _builder.append((Object)program, "");
        InputOutput.println((Object)_builder.toString());
        Object parsed = parser.parse(program);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"\t");
        _builder_1.append((Object)"Result: ");
        _builder_1.append(parsed, "\t");
        InputOutput.println((Object)_builder_1.toString());
        _xblockexpression = parsed;
        return _xblockexpression;
    }

    public static Parser<Object> symb(String s) {
        return new SymbolParser<Object>(s, false);
    }

    public static Parser<Object> isymb(String s) {
        return new SymbolParser<Object>(s, true);
    }

    public static Parser<Object> terminal(String regex) {
        return new TerminalParser<Object>(regex);
    }

    public static <T> List<T> nil() {
        return nil_;
    }

    @Data
    public static class Node {
        private final Object left;
        private final Object right;

        public Node(Object left, Object right) {
            this.left = left;
            this.right = right;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("left", this.left);
            b.add("right", this.right);
            return b.toString();
        }

        @Pure
        public Object getLeft() {
            return this.left;
        }

        @Pure
        public Object getRight() {
            return this.right;
        }
    }

    public static class Nil<T>
    extends List<T> {
        @Override
        public T getHead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<T> getTail() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "[]";
        }

        @Override
        public int getLength() {
            return 0;
        }
    }

    @Data
    public static class Cons<T>
    extends List<T> {
        private final T head;
        private final List<T> tail;
        private final int length;

        public Cons(T head) {
            this(head, ParserCombinator.nil());
        }

        public Cons(T head, List<T> tail) {
            int _plus;
            this.head = head;
            this.tail = tail;
            int _length = tail.getLength();
            this.length = _plus = _length + 1;
        }

        public String toString() {
            String _xblockexpression = null;
            StringBuffer ret = new StringBuffer("[");
            List p = this;
            boolean first = true;
            while (p instanceof Cons) {
                if (first) {
                    first = false;
                } else {
                    ret.append(", ");
                }
                ret.append(p.head);
                p = p.tail;
            }
            ret.append("]");
            _xblockexpression = ret.toString();
            return _xblockexpression;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.head == null ? 0 : this.head.hashCode());
            result = 31 * result + (this.tail == null ? 0 : this.tail.hashCode());
            result = 31 * result + this.length;
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cons other = (Cons)obj;
            if (this.head == null ? other.head != null : !this.head.equals(other.head)) {
                return false;
            }
            if (this.tail == null ? other.tail != null : !this.tail.equals(other.tail)) {
                return false;
            }
            return other.length == this.length;
        }

        @Override
        @Pure
        public T getHead() {
            return this.head;
        }

        @Override
        @Pure
        public List<T> getTail() {
            return this.tail;
        }

        @Override
        @Pure
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class List<T> {
        public abstract T getHead();

        public abstract List<T> getTail();

        public abstract int getLength();

        public List<T> push(T e) {
            return new Cons<T>(e, this);
        }
    }

    public static class TerminalParser<T>
    extends Parser<T> {
        private final Pattern pattern;

        public TerminalParser(String regex) {
            Pattern _compile;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"^(?s)");
            _builder.append((Object)regex, "");
            _builder.append((Object)"(.*)$");
            this.pattern = _compile = Pattern.compile(_builder.toString());
        }

        @Override
        public Result parseTrimmed(ParserState state) {
            Result _xblockexpression = null;
            Matcher matcher = this.pattern.matcher(state.rest);
            Result _xifexpression = null;
            boolean _matches = matcher.matches();
            if (_matches) {
                String _group = matcher.group(1);
                Cons<Object> _cons = new Cons<Object>(_group, state.stack);
                String _group_1 = matcher.group(2);
                _xifexpression = new Result(true, _cons, _group_1, state.longestFailure);
            } else {
                _xifexpression = state.fail();
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/");
            String _string = this.pattern.toString();
            _builder.append((Object)_string, "");
            _builder.append((Object)"/");
            return _builder.toString();
        }
    }

    @Data
    public static class SymbolParser<T>
    extends Parser<T> {
        private final String symbol;
        private final boolean ignored;

        @Override
        public Result parseTrimmed(ParserState state) {
            Result _xifexpression = null;
            boolean _startsWith = state.rest.startsWith(this.symbol);
            if (_startsWith) {
                Result _xblockexpression = null;
                Cons<Object> _xifexpression_1 = null;
                _xifexpression_1 = !this.ignored ? new Cons<Object>(this.symbol, state.stack) : state.stack;
                Cons<Object> st = _xifexpression_1;
                int _length = this.symbol.length();
                String _substring = state.rest.substring(_length);
                _xifexpression = _xblockexpression = new Result(true, st, _substring, state.longestFailure);
            } else {
                _xifexpression = state.fail();
            }
            return _xifexpression;
        }

        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"\"");
            _builder.append((Object)this.symbol, "");
            _builder.append((Object)"\"");
            String _xifexpression = null;
            _xifexpression = this.ignored ? "!" : "";
            _builder.append((Object)_xifexpression, "");
            return _builder.toString();
        }

        public SymbolParser(String symbol, boolean ignored) {
            this.symbol = symbol;
            this.ignored = ignored;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
            result = 31 * result + (this.ignored ? 1231 : 1237);
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SymbolParser other = (SymbolParser)obj;
            if (this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol)) {
                return false;
            }
            return other.ignored == this.ignored;
        }

        @Pure
        public String getSymbol() {
            return this.symbol;
        }

        @Pure
        public boolean isIgnored() {
            return this.ignored;
        }
    }

    @Data
    public static class MultParser<T>
    extends Parser<T> {
        private final Parser<T> left;
        private final int lower;
        private final int upper;
        private final boolean elemsAsSet;
        private final Parser<T> separator;

        @Override
        public Result parseTrimmed(ParserState state) {
            Result _xblockexpression = null;
            String next = state.rest;
            LinkedHashSet<Object> elems = new LinkedHashSet<Object>();
            Cons<Object> _xifexpression = null;
            _xifexpression = this.elemsAsSet ? new Cons<Object>(elems, state.stack) : state.stack;
            List st = _xifexpression;
            Result ret = new Result(true, st, next, state.longestFailure);
            int count = 0;
            boolean goon = true;
            do {
                List<Object> _xifexpression_1 = null;
                _xifexpression_1 = this.elemsAsSet ? ParserCombinator.nil() : st;
                ParserState _parserState = new ParserState(_xifexpression_1, next, ret.state.longestFailure);
                Result r = this.left.parseInternal(_parserState);
                if (r.success) {
                    Result _result;
                    String _rest;
                    boolean _notEquals_1;
                    ++count;
                    if (this.elemsAsSet) {
                        boolean _notEquals;
                        List<Object> _stack = r.getStack();
                        int _length = _stack.getLength();
                        boolean bl = _notEquals = _length != 1;
                        if (_notEquals) {
                            throw new RuntimeException();
                        }
                        List<Object> _stack_1 = r.getStack();
                        Object _head = _stack_1.getHead();
                        elems.add(_head);
                    } else {
                        List<Object> _stack_2 = r.getStack();
                        st = _stack_2;
                    }
                    boolean bl = _notEquals_1 = !Objects.equal(this.separator, null);
                    if (_notEquals_1) {
                        ParserState _stateWithStack = r.stateWithStack(st);
                        Result tr = this.separator.parseInternal(_stateWithStack);
                        if (tr.success) {
                            List<Object> _stack_3 = tr.getStack();
                            st = _stack_3;
                            r = tr;
                        } else {
                            goon = false;
                        }
                    }
                    next = _rest = r.getRest();
                    ParserState _stateWithStack_1 = r.stateWithStack(st);
                    ret = _result = new Result(true, _stateWithStack_1);
                    continue;
                }
                goon = false;
            } while (goon && (this.upper < 0 || count < this.upper));
            if (count < this.lower) {
                return state.fail();
            }
            _xblockexpression = ret;
            return _xblockexpression;
        }

        public String toString() {
            Object _xifexpression = null;
            if (this.lower == 0) {
                if (this.upper == -1) {
                    return "*";
                }
                if (this.upper == 1) {
                    return "?";
                }
            } else if (this.lower == 1 && this.upper == -1) {
                return "+";
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"{");
            _builder.append((Object)this.lower, "");
            _builder.append((Object)", ");
            _builder.append((Object)this.upper, "");
            _builder.append((Object)")");
            return _builder.toString();
        }

        public MultParser(Parser<T> left, int lower, int upper, boolean elemsAsSet, Parser<T> separator) {
            this.left = left;
            this.lower = lower;
            this.upper = upper;
            this.elemsAsSet = elemsAsSet;
            this.separator = separator;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + this.lower;
            result = 31 * result + this.upper;
            result = 31 * result + (this.elemsAsSet ? 1231 : 1237);
            result = 31 * result + (this.separator == null ? 0 : this.separator.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultParser other = (MultParser)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (other.lower != this.lower) {
                return false;
            }
            if (other.upper != this.upper) {
                return false;
            }
            if (other.elemsAsSet != this.elemsAsSet) {
                return false;
            }
            return !(this.separator == null ? other.separator != null : !this.separator.equals(other.separator));
        }

        @Pure
        public Parser<T> getLeft() {
            return this.left;
        }

        @Pure
        public int getLower() {
            return this.lower;
        }

        @Pure
        public int getUpper() {
            return this.upper;
        }

        @Pure
        public boolean isElemsAsSet() {
            return this.elemsAsSet;
        }

        @Pure
        public Parser<T> getSeparator() {
            return this.separator;
        }
    }

    @Data
    public static class DroppingParser<T>
    extends Parser<T> {
        private final Parser<T> wrapped;

        @Override
        public Result parseTrimmed(ParserState state) {
            Result _xblockexpression = null;
            Result ret = this.wrapped.parseInternal(state);
            Result _xifexpression = null;
            if (ret.success) {
                String _rest = ret.getRest();
                _xifexpression = new Result(true, state.stack, _rest, ret.state.longestFailure);
            } else {
                _xifexpression = ret;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public DroppingParser(Parser<T> wrapped) {
            this.wrapped = wrapped;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.wrapped == null ? 0 : this.wrapped.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DroppingParser other = (DroppingParser)obj;
            return !(this.wrapped == null ? other.wrapped != null : !this.wrapped.equals(other.wrapped));
        }

        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Parser<T> getWrapped() {
            return this.wrapped;
        }
    }

    @Data
    public static class ThenParser<T>
    extends Parser<T> {
        private final Parser<T> left;
        private final Parser<T> right;

        @Override
        public Result parseTrimmed(ParserState state) {
            Result _xblockexpression = null;
            Result retl = this.left.parseInternal(state);
            Result _xifexpression = null;
            if (retl.success) {
                Result retr;
                Result _xblockexpression_1 = null;
                _xifexpression = _xblockexpression_1 = (retr = this.right.parseInternal(retl.state));
            } else {
                _xifexpression = retl;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"(");
            _builder.append(this.left, "");
            _builder.append((Object)" ");
            _builder.append(this.right, "");
            _builder.append((Object)")");
            return _builder.toString();
        }

        public ThenParser(Parser<T> left, Parser<T> right) {
            this.left = left;
            this.right = right;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ThenParser other = (ThenParser)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        @Pure
        public Parser<T> getLeft() {
            return this.left;
        }

        @Pure
        public Parser<T> getRight() {
            return this.right;
        }
    }

    @Data
    public static class OrParser<T>
    extends Parser<T> {
        private final Parser<T> left;
        private final Parser<T> right;

        @Override
        public Result parseTrimmed(ParserState state) {
            Result _parseInternal;
            Result ret = this.left.parseInternal(state);
            if (ret.success) {
                return ret;
            }
            ParserState _withLongestFailureOf = state.withLongestFailureOf(ret.state);
            ret = _parseInternal = this.right.parseInternal(_withLongestFailureOf);
            return ret;
        }

        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"(");
            _builder.append(this.left, "");
            _builder.append((Object)" | ");
            _builder.append(this.right, "");
            _builder.append((Object)")");
            return _builder.toString();
        }

        public OrParser(Parser<T> left, Parser<T> right) {
            this.left = left;
            this.right = right;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OrParser other = (OrParser)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        @Pure
        public Parser<T> getLeft() {
            return this.left;
        }

        @Pure
        public Parser<T> getRight() {
            return this.right;
        }
    }

    public static class WrappingParser<T>
    extends Parser<T> {
        private Parser<T> wrappedParser;

        @Override
        public Result parseTrimmed(ParserState state) {
            return this.wrappedParser.parseInternal(state);
        }

        public Parser<T> set(Parser<T> wrappedParser) {
            this.wrappedParser = wrappedParser;
            return this.wrappedParser;
        }

        public String toString() {
            return "wrapping!";
        }
    }

    @Data
    public static class CreatingParser<T>
    extends Parser<T> {
        private final Class<? extends T> type;
        private final Parser<T> wrappedParser;

        @Override
        public Result parseTrimmed(ParserState state) {
            Result _xblockexpression = null;
            Result ret = this.wrappedParser.parseInternal(state);
            Result _xifexpression = null;
            if (ret.success) {
                Constructor<?> _get;
                Result _xblockexpression_1 = null;
                Constructor<?>[] _constructors = this.type.getConstructors();
                Constructor<?> cons = _get = _constructors[0];
                List<Object> st = ret.getStack();
                int _parameterCount = cons.getParameterCount();
                Object[] args = new Object[_parameterCount];
                for (int i = 0; i < args.length; ++i) {
                    Object _head;
                    int _length = args.length;
                    int _minus = _length - i;
                    int _minus_1 = _minus - 1;
                    args[_minus_1] = _head = st.getHead();
                    List<Object> _tail = st.getTail();
                    st = _tail;
                }
                Object key = null;
                try {
                    Object _newInstance = cons.newInstance(args);
                    key = _newInstance;
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"could not create ");
                        String _string = cons.toString();
                        _builder.append((Object)_string, "");
                        _builder.append((Object)" with ");
                        Object[] _converted_args = args;
                        java.util.List _list = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_args)));
                        _builder.append((Object)_list, "");
                        throw new RuntimeException(_builder.toString(), e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                Cons<Object> _cons = new Cons<Object>(key, st);
                String _rest = ret.getRest();
                _xifexpression = _xblockexpression_1 = new Result(true, _cons, _rest, ret.state.longestFailure);
            } else {
                _xifexpression = ret;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"(");
            _builder.append(this.wrappedParser, "");
            _builder.append((Object)")[");
            String _simpleName = this.type.getSimpleName();
            _builder.append((Object)_simpleName, "");
            _builder.append((Object)"]");
            return _builder.toString();
        }

        public CreatingParser(Class<? extends T> type, Parser<T> wrappedParser) {
            this.type = type;
            this.wrappedParser = wrappedParser;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.wrappedParser == null ? 0 : this.wrappedParser.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreatingParser other = (CreatingParser)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.wrappedParser == null ? other.wrappedParser != null : !this.wrappedParser.equals(other.wrappedParser));
        }

        @Pure
        public Class<? extends T> getType() {
            return this.type;
        }

        @Pure
        public Parser<T> getWrappedParser() {
            return this.wrappedParser;
        }
    }

    @Data
    public static class NodeCreatingParser<T>
    extends Parser<T> {
        private final Parser<T> wrapped;
        private final String typeName;
        private final String[] argNames;

        @Override
        public Result parseTrimmed(ParserState state) {
            Result _xblockexpression = null;
            Result ret = this.wrapped.parseInternal(state);
            Result _xifexpression = null;
            if (ret.success) {
                Result _xblockexpression_1 = null;
                List<Object> st = ret.getStack();
                ArrayList<Pair<String, Object>> slots = new ArrayList<Pair<String, Object>>();
                java.util.List _reverse = ListExtensions.reverse((java.util.List)((java.util.List)Conversions.doWrapArray((Object)this.argNames)));
                for (String argName : _reverse) {
                    Object _head = st.getHead();
                    Pair _mappedTo = Pair.of((Object)argName, (Object)_head);
                    slots.add((Pair<String, Object>)_mappedTo);
                    List<Object> _tail = st.getTail();
                    st = _tail;
                }
                GenericNode key = new GenericNode(this.typeName, slots);
                Cons<Object> _cons = new Cons<Object>(key, st);
                String _rest = ret.getRest();
                _xifexpression = _xblockexpression_1 = new Result(true, _cons, _rest, ret.state.longestFailure);
            } else {
                _xifexpression = ret;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public NodeCreatingParser(Parser<T> wrapped, String typeName, String[] argNames) {
            this.wrapped = wrapped;
            this.typeName = typeName;
            this.argNames = argNames;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.wrapped == null ? 0 : this.wrapped.hashCode());
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            result = 31 * result + (this.argNames == null ? 0 : Arrays.deepHashCode(this.argNames));
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeCreatingParser other = (NodeCreatingParser)obj;
            if (this.wrapped == null ? other.wrapped != null : !this.wrapped.equals(other.wrapped)) {
                return false;
            }
            if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
                return false;
            }
            return !(this.argNames == null ? other.argNames != null : !Arrays.deepEquals(this.argNames, other.argNames));
        }

        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Parser<T> getWrapped() {
            return this.wrapped;
        }

        @Pure
        public String getTypeName() {
            return this.typeName;
        }

        @Pure
        public String[] getArgNames() {
            return this.argNames;
        }
    }

    @Data
    public static class GenericNode {
        private final String typeName;
        private final Collection<Pair<String, Object>> slots;

        public GenericNode(String typeName, Collection<Pair<String, Object>> slots) {
            this.typeName = typeName;
            this.slots = slots;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            result = 31 * result + (this.slots == null ? 0 : this.slots.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericNode other = (GenericNode)obj;
            if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
                return false;
            }
            return !(this.slots == null ? other.slots != null : !this.slots.equals(other.slots));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("typeName", (Object)this.typeName);
            b.add("slots", this.slots);
            return b.toString();
        }

        @Pure
        public String getTypeName() {
            return this.typeName;
        }

        @Pure
        public Collection<Pair<String, Object>> getSlots() {
            return this.slots;
        }
    }

    public static abstract class Parser<T> {
        public Parser<T> or(Parser<T> o) {
            return new OrParser<T>(this, o);
        }

        public Parser<T> then(Parser<T> o) {
            return new ThenParser<T>(this, o);
        }

        public Parser<T> mult(int lower, int upper) {
            return new MultParser(this, lower, upper, false, null);
        }

        public Parser<T> mult(int lower, int upper, Parser<T> separator) {
            return new MultParser<T>(this, lower, upper, false, separator);
        }

        public Parser<T> multSet(int lower, int upper) {
            return new MultParser(this, lower, upper, true, null);
        }

        public Parser<T> multSet(int lower, int upper, Parser<T> separator) {
            return new MultParser<T>(this, lower, upper, true, separator);
        }

        public abstract Result parseTrimmed(ParserState var1);

        public Result parseInternal(ParserState state) {
            String _ignore = this.ignore(state.rest);
            ParserState _withRest = state.withRest(_ignore);
            return this.parseTrimmed(_withRest);
        }

        public String ignore(String s) {
            return s.replaceFirst("^(\\s|--.*)*", "");
        }

        public T parse(String cs) {
            Object _head;
            boolean _notEquals_1;
            boolean _notEquals;
            Object _xblockexpression = null;
            List<Object> _nil = ParserCombinator.nil();
            ParserState _parserState = new ParserState(_nil, cs, null);
            Result parsed = this.parseInternal(_parserState);
            boolean _failure = parsed.getFailure();
            if (_failure) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"error: could not parse ");
                _builder.append((Object)parsed, "");
                throw new RuntimeException(_builder.toString());
            }
            String _rest = parsed.getRest();
            String _ignore = this.ignore(_rest);
            int _length = _ignore.length();
            boolean bl = _notEquals = _length != 0;
            if (_notEquals) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"parsing incomplete: ");
                _builder_1.append((Object)parsed, "");
                throw new RuntimeException(_builder_1.toString());
            }
            List<Object> _stack = parsed.getStack();
            int _length_1 = _stack.getLength();
            boolean bl2 = _notEquals_1 = _length_1 != 1;
            if (_notEquals_1) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"warning: more than one element left on stack: ");
                _builder_2.append((Object)parsed, "");
                InputOutput.println((Object)_builder_2.toString());
            }
            List<Object> _stack_1 = parsed.getStack();
            _xblockexpression = _head = _stack_1.getHead();
            return (T)_xblockexpression;
        }

        public CreatingParser<T> create(Class<? extends T> c, Object ... args) {
            return new CreatingParser<T>(c, this);
        }

        public NodeCreatingParser<T> create(String typeName, String ... argNames) {
            return new NodeCreatingParser(this, typeName, argNames);
        }
    }

    @Data
    public static class ParserState {
        private final List<Object> stack;
        private final String rest;
        private final ParserState longestFailure;

        public ParserState withRest(String rest) {
            return new ParserState(this.stack, rest, this.longestFailure);
        }

        public ParserState withLongestFailureOf(ParserState other) {
            return new ParserState(this.stack, this.rest, other.longestFailure);
        }

        public Result fail() {
            int _length_1;
            int _length;
            boolean _lessThan;
            ParserState _xifexpression = null;
            boolean _or = false;
            boolean _equals = Objects.equal((Object)this.longestFailure, null);
            _or = _equals ? true : (_lessThan = (_length = this.rest.length()) < (_length_1 = this.longestFailure.rest.length()));
            _xifexpression = _or ? new ParserState(this.stack, this.rest, null) : this.longestFailure;
            ParserState lf = _xifexpression;
            ParserState _parserState = new ParserState(this.stack, this.rest, lf);
            return new Result(false, _parserState);
        }

        public ParserState(List<Object> stack, String rest, ParserState longestFailure) {
            this.stack = stack;
            this.rest = rest;
            this.longestFailure = longestFailure;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
            result = 31 * result + (this.rest == null ? 0 : this.rest.hashCode());
            result = 31 * result + (this.longestFailure == null ? 0 : this.longestFailure.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParserState other = (ParserState)obj;
            if (this.stack == null ? other.stack != null : !this.stack.equals(other.stack)) {
                return false;
            }
            if (this.rest == null ? other.rest != null : !this.rest.equals(other.rest)) {
                return false;
            }
            return !(this.longestFailure == null ? other.longestFailure != null : !this.longestFailure.equals(other.longestFailure));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("stack", this.stack);
            b.add("rest", (Object)this.rest);
            b.add("longestFailure", (Object)this.longestFailure);
            return b.toString();
        }

        @Pure
        public List<Object> getStack() {
            return this.stack;
        }

        @Pure
        public String getRest() {
            return this.rest;
        }

        @Pure
        public ParserState getLongestFailure() {
            return this.longestFailure;
        }
    }

    @Data
    public static class Result {
        private final boolean success;
        private final ParserState state;

        public Result(boolean success, List<Object> stack, String rest, ParserState longestFailure) {
            this(success, new ParserState(stack, rest, longestFailure));
        }

        public Result(boolean success, ParserState state) {
            this.success = success;
            this.state = state;
        }

        public boolean getFailure() {
            return !this.success;
        }

        public List<Object> getStack() {
            return this.state.stack;
        }

        public String getRest() {
            return this.state.rest;
        }

        public ParserState getLongestFailure() {
            return this.state.longestFailure;
        }

        public ParserState stateWithStack(List<Object> st) {
            String _rest = this.getRest();
            ParserState _longestFailure = this.getLongestFailure();
            return new ParserState(st, _rest, _longestFailure);
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.success ? 1231 : 1237);
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (other.success != this.success) {
                return false;
            }
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("success", (Object)this.success);
            b.add("state", (Object)this.state);
            return b.toString();
        }

        @Pure
        public boolean isSuccess() {
            return this.success;
        }

        @Pure
        public ParserState getState() {
            return this.state;
        }
    }
}

