/*
 * Decompiled with CFR 0.152.
 */
package plug.modules.synchronization.byChannels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import plug.core.IFiredTransition;
import plug.modules.synchronization.ISynchronizedTransition;
import plug.modules.synchronization.ISynchronizingRuntime;
import plug.modules.synchronization.SynchronizationExplorer;
import plug.modules.synchronization.byChannels.IChannelSynchronizationManager;
import plug.statespace.transitions.FiredTransition;
import plug.utils.CartesianProduct;

public class FastChannelSynchronizationManager<C, T>
implements IChannelSynchronizationManager<C, T> {
    Map<Integer, ChannelProfile> channelProfileMap = new HashMap<Integer, ChannelProfile>();
    Map<Integer, ChannelSchedule> scheduledSynchronizations = new HashMap<Integer, ChannelSchedule>();
    ISynchronizingRuntime<C, T> runtime;
    private Map<Integer, AutomatonVocabulary> vocabularyByAutomaton = new HashMap<Integer, AutomatonVocabulary>();
    private final SynchronizationExplorer<C, T> syncExplorer;
    public boolean exploreSynchronization = true;
    Function<Integer, T[][]> synchronizationArrayMaker;
    Function<Integer, T[]> synchronizationArrayMaker1;
    CartesianProduct<T> cartesianProductProvider = new CartesianProduct();
    int maximumBrachingEstimation = 10;

    public FastChannelSynchronizationManager(ISynchronizingRuntime runtime) {
        this.runtime = runtime;
        this.syncExplorer = new SynchronizationExplorer(runtime);
    }

    @Override
    public void setExploreSynchronization(boolean isExploring) {
        this.exploreSynchronization = isExploring;
    }

    @Override
    public boolean getExploreSynchronization() {
        return this.exploreSynchronization;
    }

    @Override
    public void setRuntime(ISynchronizingRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public ISynchronizingRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public void registerChannel(int channelID, int requiredOutputs, int requiredInputs) {
        if (this.channelProfileMap.get(channelID) != null) {
            throw new Error("Channel " + channelID + " is already registered");
        }
        ChannelProfile profile = new ChannelProfile(requiredOutputs, requiredInputs);
        this.channelProfileMap.put(channelID, profile);
        this.scheduledSynchronizations.put(channelID, new ChannelSchedule(profile));
    }

    @Override
    public void addVocabulary(int behaviorId, int[] outputVocabulary, int[] inputVocabulary) {
        ChannelProfile profile;
        this.vocabularyByAutomaton.put(behaviorId, new AutomatonVocabulary(outputVocabulary, inputVocabulary));
        for (int channelID : outputVocabulary) {
            profile = this.channelProfileMap.get(channelID);
            profile.addOutput(behaviorId);
        }
        for (int channelID : inputVocabulary) {
            profile = this.channelProfileMap.get(channelID);
            profile.addInput(behaviorId);
        }
    }

    @Override
    public void scheduleOutput(int channelID, int behaviorID, T behavior) {
        ChannelProfile channelProfile = this.channelProfileMap.get(channelID);
        ChannelSchedule channelSchedule = this.scheduledSynchronizations.get(channelID);
        channelSchedule.scheduleOutput(channelProfile, behaviorID, behavior);
    }

    @Override
    public void scheduleInput(int channelID, int behaviorID, T behavior) {
        ChannelProfile channelProfile = this.channelProfileMap.get(channelID);
        ChannelSchedule channelSchedule = this.scheduledSynchronizations.get(channelID);
        channelSchedule.scheduleInput(channelProfile, behaviorID, behavior);
    }

    @Override
    public Collection<ISynchronizedTransition<T>> fireableTransitionsFrom(C currentConfiguration) {
        ArrayList<ISynchronizedTransition<T>> synchronizedTransitions = new ArrayList<ISynchronizedTransition<T>>();
        for (int channelID : this.scheduledSynchronizations.keySet()) {
            ChannelSchedule channelSchedule = this.scheduledSynchronizations.get(channelID);
            if (!channelSchedule.isComplete()) {
                channelSchedule.clear();
                continue;
            }
            synchronizedTransitions.addAll(this.retrieveSynchronizedTransitionsOnChannel(currentConfiguration, channelID, channelSchedule));
            channelSchedule.clear();
        }
        return synchronizedTransitions;
    }

    @Override
    public void clearSchedule() {
        for (int channelID : this.scheduledSynchronizations.keySet()) {
            this.scheduledSynchronizations.get(channelID).clear();
        }
    }

    @Override
    public boolean isComplete(int channelID) {
        ChannelSchedule channelSchedule = this.scheduledSynchronizations.get(channelID);
        return channelSchedule.isComplete();
    }

    @Override
    public void setSynchronizationArraySupplier2(Function<Integer, T[][]> synchronizationArrayMaker) {
        this.synchronizationArrayMaker = synchronizationArrayMaker;
    }

    @Override
    public void setSynchronizationArraySupplier1(Function<Integer, T[]> synchronizationArrayMaker) {
        this.synchronizationArrayMaker1 = synchronizationArrayMaker;
    }

    private Collection<ISynchronizedTransition<T>> retrieveSynchronizedTransitionsOnChannel(C current, int channelID, ChannelSchedule schedule) {
        List result = schedule.getScheduleResult();
        Consumer<Object[][]> callback = tuple -> {
            if (this.runtime.synchronizedTransitionIsActive(current, channelID, tuple[0], tuple[1])) {
                ISynchronizedTransition<Object> synchronizedTransition = this.runtime.newSynchronizedTransitionObject();
                Object[] outputBeh = (Object[])tuple[0].clone();
                Object[] inputBeh = (Object[])tuple[1].clone();
                synchronizedTransition.setSynchronizationVector(channelID);
                synchronizedTransition.addOutputBehaviors(Arrays.asList(outputBeh));
                synchronizedTransition.addInputBehaviors(Arrays.asList(inputBeh));
                result.add(synchronizedTransition);
            }
        };
        Object[][] resultHolder = this.synchronizationArrayMaker.apply(2);
        resultHolder[0] = this.synchronizationArrayMaker1.apply(schedule.outputSchedule.scheduledPerProfileEntry.length);
        resultHolder[1] = this.synchronizationArrayMaker1.apply(schedule.inputSchedule.scheduledPerProfileEntry.length);
        this.cartesianProductProvider.cartesianProduct(schedule.outputSchedule.scheduledPerProfileEntry, schedule.inputSchedule.scheduledPerProfileEntry, callback, resultHolder);
        return result;
    }

    @Override
    public IFiredTransition<C, ?> fireOneTransition(C currentConfiguration, ISynchronizedTransition<T> transition) {
        HashSet targetConfigurations = new HashSet();
        this.executeSynchronizedBehaviors(currentConfiguration, transition, targetConfigurations);
        return new FiredTransition(currentConfiguration, targetConfigurations, transition);
    }

    private void executeSynchronizedBehaviors(C initialConfiguration, ISynchronizedTransition<T> transition, Set<C> ioResults) {
        if (this.exploreSynchronization) {
            this.executeSynchronizedBehaviorsExploring(initialConfiguration, transition, ioResults);
            return;
        }
        this.executeSynchronizedBehaviorsArbitraryOrder(initialConfiguration, transition, ioResults);
    }

    private void executeSynchronizedBehaviorsArbitraryOrder(C initialConfiguration, ISynchronizedTransition<T> transition, Set<C> ioResults) {
        IFiredTransition<C, ?> fired;
        Object nowConfig = initialConfiguration;
        for (T behavior : transition.getOutputBehaviors()) {
            fired = this.runtime.executeOneTransition(nowConfig, behavior);
            if (fired != null && (nowConfig = fired.getTarget(0)) != null) continue;
            return;
        }
        for (T behavior : transition.getInputBehaviors()) {
            fired = this.runtime.executeOneTransition(nowConfig, behavior);
            if (fired != null && (nowConfig = fired.getTarget(0)) != null) continue;
            return;
        }
        ioResults.add(nowConfig);
    }

    private void executeSynchronizedBehaviorsExploring(C initialConfiguration, ISynchronizedTransition<T> transition, Set<C> ioResults) {
        this.syncExplorer.reset();
        this.syncExplorer.addOutputs(transition.getOutputBehaviors());
        this.syncExplorer.addInputs(transition.getInputBehaviors());
        this.syncExplorer.execute(initialConfiguration, ioResults);
    }

    class ChannelSchedule {
        ScheduledBehaviorList outputSchedule;
        ScheduledBehaviorList inputSchedule;
        List<ISynchronizedTransition<T>> scheduleResult;

        ChannelSchedule(ChannelProfile profile) {
            this.outputSchedule = new ScheduledBehaviorList(profile.outputProfile);
            this.inputSchedule = new ScheduledBehaviorList(profile.inputProfile);
        }

        private void scheduleInput(ChannelProfile profile, int automataID, T behavior) {
            this.inputSchedule.scheduleBehavior(profile.inputProfile, automataID, behavior);
        }

        private void scheduleOutput(ChannelProfile profile, int automataID, T behavior) {
            this.outputSchedule.scheduleBehavior(profile.outputProfile, automataID, behavior);
        }

        boolean isComplete() {
            return this.outputSchedule.isComplete() && this.inputSchedule.isComplete();
        }

        int cartesianProductSize() {
            return this.outputSchedule.cartesianProductSize() * this.inputSchedule.cartesianProductSize();
        }

        public List<ISynchronizedTransition<T>> getScheduleResult() {
            if (this.scheduleResult == null) {
                this.scheduleResult = new ArrayList(this.cartesianProductSize());
            }
            return this.scheduleResult;
        }

        void clear() {
            this.outputSchedule.clear();
            this.inputSchedule.clear();
            if (this.scheduleResult != null) {
                this.scheduleResult.clear();
            }
        }
    }

    class ScheduledBehaviorList {
        List[] scheduledPerProfileEntry;

        ScheduledBehaviorList(ChannelOperationProfile profile) {
            this.scheduledPerProfileEntry = new List[profile.getRequiredSize()];
            for (int i = 0; i < profile.getRequiredSize(); ++i) {
                this.scheduledPerProfileEntry[i] = new ArrayList(FastChannelSynchronizationManager.this.maximumBrachingEstimation);
            }
        }

        void scheduleBehavior(ChannelOperationProfile profile, int automataID, T behavior) {
            int entryID = profile.getEntryIndex(automataID);
            ArrayList scheduledBehaviors = this.scheduledPerProfileEntry[entryID];
            if (scheduledBehaviors == null) {
                this.scheduledPerProfileEntry[entryID] = scheduledBehaviors = new ArrayList(FastChannelSynchronizationManager.this.maximumBrachingEstimation);
            }
            scheduledBehaviors.add(behavior);
        }

        void clear() {
            for (int i = 0; i < this.scheduledPerProfileEntry.length; ++i) {
                this.scheduledPerProfileEntry[i].clear();
            }
        }

        boolean isComplete() {
            int n = 0;
            List[] listArray = this.scheduledPerProfileEntry;
            int n2 = listArray.length;
            if (n < n2) {
                List entriesForAutomata = listArray[n];
                return !entriesForAutomata.isEmpty();
            }
            return true;
        }

        int cartesianProductSize() {
            int result = 1;
            for (int i = 0; i < this.scheduledPerProfileEntry.length; ++i) {
                result *= this.scheduledPerProfileEntry[i].size();
            }
            return result;
        }
    }

    class AutomatonVocabulary {
        int[] outputVocabulary;
        int[] inputVocabulary;

        AutomatonVocabulary(int[] outputVocabulary, int[] inputVocabulary) {
            this.outputVocabulary = outputVocabulary;
            this.inputVocabulary = inputVocabulary;
        }
    }

    class ChannelProfile {
        ChannelOperationProfile outputProfile;
        ChannelOperationProfile inputProfile;

        ChannelProfile(int requiredOutputs, int requiredInputs) {
            this.outputProfile = new ChannelOperationProfile(requiredOutputs);
            this.inputProfile = new ChannelOperationProfile(requiredInputs);
        }

        void addOutput(int behaviorID) {
            this.outputProfile.addEntry(behaviorID);
        }

        void addInput(int behaviorID) {
            this.inputProfile.addEntry(behaviorID);
        }
    }

    class ChannelOperationProfile {
        int[] entry2processID;
        Map<Integer, Integer> automataID2entryID = new HashMap<Integer, Integer>();
        int lastIndex = 0;

        ChannelOperationProfile(int requiredSize) {
            this.entry2processID = new int[requiredSize];
        }

        void addEntry(int behaviorID) {
            this.automataID2entryID.put(behaviorID, this.lastIndex);
            this.entry2processID[this.lastIndex++] = behaviorID;
        }

        int getRequiredSize() {
            return this.entry2processID.length;
        }

        int getEntryIndex(int automataID) {
            return this.automataID2entryID.get(automataID);
        }
    }
}

