/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.expression;

import java.util.Set;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.MyParseException;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.ChannelType;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.promela.compiler.variable.VariableType;

public class ChannelOperation
extends Expression {
    private final Expression expr;

    public ChannelOperation(Token token, Expression expression) throws ParseException {
        super(token);
        this.expr = expression;
        if (!expression.getResultType().canConvert(ChannelType.UNASSIGNED_CHANNEL)) {
            throw new MyParseException("Cannot convert type in the channel operation to a channel.", this.getToken());
        }
    }

    @Override
    public String getBoolExpression() throws ParseException {
        return "_channels[" + this.expr.getIntExpression() + "]." + this.getMethodName();
    }

    private String getMethodName() throws ParseException {
        switch (this.getToken().kind) {
            case 42: {
                return "isEmpty()";
            }
            case 41: {
                return "isFull()";
            }
            case 44: {
                return "isNotEmpty()";
            }
            case 43: {
                return "isNotFull()";
            }
        }
        throw new MyParseException("Unknow kind of operation on the channel", this.getToken());
    }

    @Override
    public VariableType getResultType() throws ParseException {
        return VariableType.BOOL;
    }

    @Override
    public Set<VariableAccess> readVariables() {
        return this.expr.readVariables();
    }
}

