/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.fiacre;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Constr;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.Exp;
import obp.fiacre.model.FunctionDecl;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Seq;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import obp.fiacre.util.FiacreBuilder;
import obp.fiacre.util.TypeUtil;

public class FiacreBuilderForABCD
extends FiacreBuilder {
    public FunctionDecl createDeferredHandler(String uniqueId, Type eventPoolType, Type deferMaskType) {
        if (!TypeUtil.isQueueType(eventPoolType)) {
            System.err.println("FiacreBuilderForABCD: unsupported queue type");
            return null;
        }
        ArgumentVariable eventPool = this.argumentVariable("eventPool", eventPoolType);
        ArgumentVariable deferMask = this.argumentVariable("deferMask", deferMaskType);
        LocalVariable deferred = this.localVariable("deferred", eventPoolType);
        LocalVariable result = this.localVariable("result", eventPoolType);
        LocalVariable continueV = this.localVariable("continue", new BoolType(), this.literal(true));
        Type eType = ((Queue)TypeUtil.referencedType(eventPoolType)).getType();
        if (!TypeUtil.isUnionType(eType)) {
            System.err.println("FiacreBuilderForABCD: unsupported type");
            return null;
        }
        Union uType = (Union)TypeUtil.referencedType(eType);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        int idx = 0;
        for (Constr field : uType.getConstrList()) {
            rules.add(this.rule(field.getType() == null ? this.unionPattern(field.getName()) : this.unionPattern(field.getName(), this.any()), this.ifStmt(this.indexedExp(this.varRef(deferMask), this.literal(idx++)), this.seq(this.assign(this.varRef(deferred), this.enqueue(this.varRef(deferred), this.first(this.varRef(eventPool)))), this.assign(this.varRef(eventPool), this.dequeue(this.varRef(eventPool)))), this.assign(this.varRef(continueV), this.literal(false)))));
        }
        Seq body = this.seq(this.whileStmt(this.and(this.not(this.empty(this.varRef(eventPool))), this.varRef(continueV)), this.caseStmt(this.first(this.varRef(eventPool)), rules)), this.ifStmt(this.not(this.empty(this.varRef(eventPool))), this.seq(this.assign(this.varRef(result), this.enqueue(this.varRef(result), this.first(this.varRef(eventPool)))), this.assign(this.varRef(eventPool), this.dequeue(this.varRef(eventPool)))), null), this.whileStmt(this.not(this.empty(this.varRef(deferred))), this.seq(this.assign(this.varRef(result), this.enqueue(this.varRef(result), this.first(this.varRef(deferred)))), this.assign(this.varRef(deferred), this.dequeue(this.varRef(deferred))))), this.whileStmt(this.not(this.empty(this.varRef(eventPool))), this.seq(this.assign(this.varRef(result), this.enqueue(this.varRef(result), this.first(this.varRef(eventPool)))), this.assign(this.varRef(eventPool), this.dequeue(this.varRef(eventPool))))), this.returnStmt(this.varRef(result)));
        FunctionDecl func = this.functionDecl("processDeferred_" + uniqueId, new ArgumentVariable[]{eventPool, deferMask}, eventPoolType, new LocalVariable[]{deferred, result, continueV}, (Statement)body);
        return func;
    }

    public List<Declaration> createFifo(String name, Type type, Exp size, boolean isBlocking) {
        ProcessDecl process = new ProcessDecl();
        Type getType = null;
        process.setName(name);
        ParamPortDecl putP = this.portDecl("put", type, true);
        process.addPort(putP);
        if (isBlocking) {
            getType = type;
        } else {
            Record re = this.record(this.field("value", type), this.field("valid", new BoolType()));
            getType = this.type(this.typeDecl("fifoGetProtocol", re));
        }
        ParamPortDecl getP = this.portDecl("get", getType, false);
        process.addPort(getP);
        Queue qType = this.queueType(size, type);
        LocalVariable fifoVar = this.localVariable("fifo", qType, this.initialValue(qType));
        process.addVar(fifoVar);
        LocalVariable localVar = this.localVariable("localV", getType, this.initialValue(getType));
        process.addVar(localVar);
        this.attachComments(localVar, "@ltt");
        Transition mainTransition = this.transition("Start", process);
        process.addTransition(mainTransition);
        Statement stmtPut = this.createPutHandler(putP, fifoVar, localVar, mainTransition, isBlocking);
        Statement stmtGet = this.createGetHandler(getP, fifoVar, localVar, mainTransition, isBlocking);
        mainTransition.setAction(this.select(stmtPut, stmtGet));
        if (isBlocking) {
            return Arrays.asList(process);
        }
        return Arrays.asList(((TypeId)getType).getDecl(), process);
    }

    private Statement createPutHandler(PortDecl port, LocalVariable fifoV, LocalVariable localV, Transition mainTransition, boolean fifoIsBlocking) {
        IfStmt ifPut = this.ifStmt(this.not(this.full(this.varRef(fifoV))), this.seq(this.oneReception(port, this.valuePattern(localV, !fifoIsBlocking)), this.assign(this.varRef(fifoV), this.enqueue(this.varRef(fifoV), this.valueExp(localV, !fifoIsBlocking)))), null);
        this.attachComment(ifPut, "Fifo blocking write implementation");
        return this.seq(ifPut, this.loopOn(mainTransition));
    }

    private Statement createGetHandler(PortDecl port, LocalVariable fifoV, LocalVariable localV, Transition mainTransition, boolean fifoIsBlocking) {
        IfStmt ifGet;
        if (fifoIsBlocking) {
            ifGet = this.ifStmt(this.not(this.empty(this.varRef(fifoV))), this.seq(this.assign(this.varRef(localV), this.first(this.varRef(fifoV))), this.assign(this.varRef(fifoV), this.dequeue(this.varRef(fifoV))), this.emission(port, this.varRef(localV))), null);
            this.attachComment(ifGet, "Fifo blocking read implementation");
        } else {
            ifGet = this.ifStmt(this.not(this.empty(this.varRef(fifoV))), this.seq(this.assign(this.valuePattern(localV, true), this.first(this.varRef(fifoV))), this.assign(this.varRef(fifoV), this.dequeue(this.varRef(fifoV))), this.assign(this.fieldPattern(this.varRef(localV), "valid"), this.literal(true)), this.emission(port, this.varRef(localV))), this.seq(this.assign(this.fieldPattern(this.varRef(localV), "valid"), this.literal(false)), this.emission(port, this.varRef(localV))));
            this.attachComment(ifGet, "Fifo non-blocking read implementation");
        }
        return this.seq(ifGet, this.loopOn(mainTransition));
    }

    private Pattern valuePattern(LocalVariable localV, boolean isRecord) {
        if (isRecord) {
            return this.fieldPattern(this.varRef(localV), "value");
        }
        return this.varRef(localV);
    }

    private Exp valueExp(LocalVariable localV, boolean isRecord) {
        if (isRecord) {
            return this.selectedExp(this.varRef(localV), "value");
        }
        return this.varRef(localV);
    }
}

