/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.main;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import obp.cc.ConcreteContext;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.simulation.InteractiveSimulator;
import obp.fiacre.compiler.ProgramGenerator;
import obp.obs.Observer;
import obp.simulation.component.ObserverDialog;
import obp.simulation.component.SimulationView;
import obp.simulation.controler.SimulationControler;
import obp.simulation.listener.ButtonListener;
import obp.simulation.listener.ChangeConfigListener;
import obp.simulation.listener.DelayChangeListener;
import obp.simulation.listener.ListMouseListener;
import obp.simulation.listener.TransitionSelectionListener;
import obp.simulation.model.ConfigurationModel;
import obp.simulation.model.DiagramModel;
import obp.simulation.model.GraphicsModel;
import obp.simulation.model.TransitionModel;
import obp.simulation.model.TransitionRenderer;

public class Simulation {
    private static final String directoryExtension = ".obp";
    private static final String javaBasePackage = null;
    private static final String classDirectoryName = "bin";
    private static final String confsDirectoryName = "confs";
    File outputDirectory;
    private File cdlFile;
    private File programFile;
    private ConcreteContext cc;
    private InteractiveSimulator simulator;
    private SimulationView view;
    private File dotFile;

    public Simulation(File cdlFile, File programFile, ConcreteContext cc) {
        this.cdlFile = cdlFile;
        this.programFile = programFile;
        this.cc = cc;
    }

    private void initObpSimulator() {
        StringTokenizer st = new StringTokenizer(this.programFile.getName(), ".");
        String programName = st.nextToken();
        this.outputDirectory = new File(this.programFile.getParentFile(), programName + directoryExtension);
        File classDirectory = new File(this.outputDirectory, classDirectoryName);
        File configDirectory = new File(this.outputDirectory, confsDirectoryName);
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
        String programQualifiedName = ProgramGenerator.getProgramQualifiedName(javaBasePackage, programName);
        ProgramLoader.FromClass loader = new ProgramLoader.FromClass(programQualifiedName, classDirectory);
        this.simulator = new InteractiveSimulator(loader, this.cc);
        if (this.cc != null) {
            this.simulator.setConfigurationOutputFile(new File(this.outputDirectory, "confs/sim_" + this.cc.getName() + ".confs"));
        } else {
            this.simulator.setConfigurationOutputFile(new File(this.outputDirectory, "confs/sim_" + programName + ".confs"));
        }
        this.simulator.start();
    }

    public void start() {
        this.initObpSimulator();
        TransitionModel transitionModel = new TransitionModel();
        ConfigurationModel configurationModel = new ConfigurationModel();
        DiagramModel diagramModel = new DiagramModel(this.simulator.getAction(), this.simulator.getSymbols());
        try {
            this.dotFile = File.createTempFile("graph_tmp", ".dot");
            this.dotFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GraphicsModel graphicsModel = new GraphicsModel(this.dotFile);
        this.view = new SimulationView("Simulation", this.simulator, this.dotFile);
        SimulationControler simulationControler = new SimulationControler(configurationModel, transitionModel, diagramModel, graphicsModel, this.simulator, this.view);
        this.view.getGraphicsPanel().setGraphFile(this.dotFile);
        transitionModel.addObserver(this.view.getTransitionPanel());
        configurationModel.addObserver(this.view.getConfigurationPanel());
        configurationModel.addObserver(this.view.getGraphicsPanel());
        graphicsModel.addObserver(this.view.getGraphicsPanel());
        diagramModel.addObserver(this.view.getDiagramPanel());
        this.view.getGraphicsPanel().addObserver(simulationControler);
        this.view.getTransitionPanel().addCellRenderer(new TransitionRenderer(simulationControler, configurationModel));
        if (this.cc != null) {
            this.view.getToolBar().setContexte(this.cc.getName());
            ArrayList<ObserverDialog> obsViewerList = new ArrayList<ObserverDialog>();
            for (Observer obs : this.cc.getObserverList()) {
                obsViewerList.add(new ObserverDialog((Frame)this.view, obs));
            }
            this.view.getConfigurationPanel().setObserverList(obsViewerList);
            simulationControler.setObsViewerList(obsViewerList);
        }
        ButtonListener bl = new ButtonListener(this.view, simulationControler);
        this.view.getMenu().addListener(bl);
        this.view.getToolBar().addListener(bl);
        this.view.getToolBar().addDelayListener(new DelayChangeListener(simulationControler));
        this.view.getTransitionPanel().addListMouseListener(new ListMouseListener(this.view, simulationControler));
        this.view.getTransitionPanel().addListSelectionListenner(new TransitionSelectionListener(this.view, this.simulator));
        this.view.getConfigurationPanel().getIdConfigTextField().addCaretListener(new ChangeConfigListener(this.view.getConfigurationPanel(), simulationControler));
        this.view.getConsole().addText("Simulation starting:");
        if (this.cdlFile != null) {
            this.view.getConsole().addText("Cdl file: " + this.cdlFile.getPath());
        }
        if (this.cc != null) {
            this.view.getConsole().addText("Context: " + this.cc.getName());
        }
        this.view.getConsole().addText("Program file: " + this.programFile.getPath());
        this.view.getConsole().addText("Output File: " + this.simulator.getConfigutationOutputFile().getAbsolutePath());
        this.view.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                Simulation.this.dotFile.delete();
                Simulation.this.view.getGraphicsPanel().exit();
            }
        });
        simulationControler.initSimulation(this.simulator.currentConfiguration);
        this.view.setDefaultCloseOperation(2);
    }

    public void dispose() {
        this.view.dispose();
    }
}

