/*
 * Decompiled with CFR 0.152.
 */
package obp.obs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.obs.ObsVisitor;
import obp.obs.State;
import obp.obs.Transition;
import obp.property.Scope;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class Observer
implements BoostObject {
    private String name;
    private String clock;
    private Scope scope;
    private State startState;
    private final List<State> stateList = new ArrayList<State>();
    private final List<Transition> transitionList = new ArrayList<Transition>();
    private boolean greedy = true;

    public Observer() {
    }

    protected Observer(Boost boost) {
        boost.register((BoostObject)this);
        this.name = boost.readString();
        this.clock = boost.readString();
        this.scope = (Scope)boost.readObject(Scope.class);
        this.startState = (State)boost.readObject(State.class);
        for (Object oneChild : BoostUtil.readObjectList((Boost)boost, State.class)) {
            this.stateList.add((State)oneChild);
        }
        for (Object oneChild : BoostUtil.readObjectList((Boost)boost, Transition.class)) {
            this.transitionList.add((Transition)oneChild);
        }
        this.greedy = boost.readBoolean();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    public String getClock() {
        return this.clock;
    }

    public void setClock(String newValue) {
        if (this.clock == null ? newValue != null : !this.clock.equals(newValue)) {
            this.clock = newValue;
        }
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope newValue) {
        if (this.scope == null ? newValue != null : !this.scope.equals(newValue)) {
            this.scope = newValue;
        }
    }

    public State getStartState() {
        return this.startState;
    }

    public void setStartState(State newValue) {
        if (this.startState == null ? newValue != null : !this.startState.equals(newValue)) {
            this.startState = newValue;
        }
    }

    public List<State> getStateList() {
        return Collections.unmodifiableList(this.stateList);
    }

    public int getStateCount() {
        return this.stateList.size();
    }

    public State getState(int index) {
        if (index < 0 || index >= this.getStateCount()) {
            return null;
        }
        return this.stateList.get(index);
    }

    public void addState(State newValue) {
        this.addState(this.getStateCount(), newValue);
    }

    public void addState(int index, State newValue) {
        this.stateList.add(index, newValue);
    }

    public State setState(int index, State newValue) {
        return this.stateList.set(index, newValue);
    }

    public void addAllState(Collection<State> toAddList) {
        for (State newValue : toAddList) {
            this.addState(this.getStateCount(), newValue);
        }
    }

    public void removeState(State value) {
        int index = this.stateList.indexOf(value);
        if (index >= 0) {
            this.removeState(index);
        }
    }

    public void removeState(int index) {
        this.stateList.remove(index);
    }

    public List<Transition> getTransitionList() {
        return Collections.unmodifiableList(this.transitionList);
    }

    public int getTransitionCount() {
        return this.transitionList.size();
    }

    public Transition getTransition(int index) {
        if (index < 0 || index >= this.getTransitionCount()) {
            return null;
        }
        return this.transitionList.get(index);
    }

    public void addTransition(Transition newValue) {
        this.addTransition(this.getTransitionCount(), newValue);
    }

    public void addTransition(int index, Transition newValue) {
        this.transitionList.add(index, newValue);
    }

    public Transition setTransition(int index, Transition newValue) {
        return this.transitionList.set(index, newValue);
    }

    public void addAllTransition(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addTransition(this.getTransitionCount(), newValue);
        }
    }

    public void removeTransition(Transition value) {
        int index = this.transitionList.indexOf(value);
        if (index >= 0) {
            this.removeTransition(index);
        }
    }

    public void removeTransition(int index) {
        this.transitionList.remove(index);
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean newValue) {
        if (this.greedy != newValue) {
            this.greedy = newValue;
        }
    }

    public void writeToBoost(Boost boost) {
        boost.writeString(this.name);
        boost.writeString(this.clock);
        boost.writeObject((BoostObject)this.scope);
        boost.writeObject((BoostObject)this.startState);
        BoostUtil.writeObjectCollection((Boost)boost, this.stateList);
        BoostUtil.writeObjectCollection((Boost)boost, this.transitionList);
        boost.writeBoolean(this.greedy);
    }

    public void accept(ObsVisitor visitor) {
        visitor.visitObserver(this);
    }
}

