/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.ArrayList;
import java.util.List;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Seq;
import obp.fiacre.util.FiacrePrinter;

public class TransitionBranch {
    private final List<Exp> conditionList = new ArrayList<Exp>();
    private final Seq action = new Seq();
    private final String source;
    private boolean complete;

    public TransitionBranch(String source) {
        this.source = source;
    }

    public List<Exp> getConditionList() {
        return this.conditionList;
    }

    public Seq getAction() {
        return this.action;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public int hashCode() {
        int total = 17;
        total = 37 * total + this.source.hashCode();
        total = 37 * total + this.conditionList.hashCode();
        total = 37 * total + this.action.getStatementList().hashCode();
        total = 37 * total + (this.complete ? 2 : 1);
        return total;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransitionBranch) {
            TransitionBranch other = (TransitionBranch)obj;
            if (!this.source.equals(other.source)) {
                return false;
            }
            if (!this.conditionList.equals(other.conditionList)) {
                return false;
            }
            if (!this.action.getStatementList().equals(other.getAction().getStatementList())) {
                return false;
            }
            return this.complete == other.complete;
        }
        return false;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("From ");
        string.append(this.source);
        string.append("\n");
        string.append("Cond:\n");
        for (Exp condition : this.conditionList) {
            string.append("- ");
            string.append(FiacrePrinter.toString(condition));
            string.append("\n");
        }
        string.append("Action:\n");
        string.append(FiacrePrinter.toString(this.action));
        string.append("\n");
        if (this.complete) {
            string.append("(complete)\n");
        }
        return string.toString();
    }
}

