/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Program;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.State;
import obp.fiacre.model.Statement;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.parser.FiacreLexer;
import obp.fiacre.parser.FiacreParser;
import obp.fiacre.util.FracBranch;
import obp.fiacre.util.IfElseTransformer;

public class FiacreUtil {
    public static final Pattern fracPattern = Pattern.compile("^([a-zA-Z][a-zA-Z0-9]*)_([0-9]+)_([tsv])(.*)$");
    public static final Pattern fracTransitionPattern = Pattern.compile("([a-zA-Z][a-zA-Z0-9]*_[0-9]+_t[0-9]+)_?");
    public static final String fiacreInitialStateName = "init";

    public static Program loadProgram(File source) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        Program object = FiacreUtil.loadProgram(in);
        ((InputStream)in).close();
        return object;
    }

    public static Program loadProgram(String source) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(source.getBytes()));
        Program object = FiacreUtil.loadProgram(in);
        ((InputStream)in).close();
        return object;
    }

    public static Program loadProgram(InputStream in) throws Exception {
        FiacreParser parser = new FiacreParser(new FiacreLexer(in));
        parser.parse();
        Program object = parser.getObject();
        IfElseTransformer.transform(object);
        return object;
    }

    public static <T extends Declaration> T findDeclaration(String name, Class<T> type, Program program) {
        for (Declaration decl : program.getDeclarationList()) {
            if (!decl.getName().equals(name) || !type.isInstance(decl)) continue;
            return (T)((Declaration)type.cast(decl));
        }
        return null;
    }

    public static State findState(String name, ProcessDecl process) {
        for (State state : process.getStateList()) {
            if (!state.getName().equals(name)) continue;
            return state;
        }
        return null;
    }

    public static Map<String, FracBranch> identifyAllFracBranches(Program program) {
        HashMap<String, FracBranch> transitions = new HashMap<String, FracBranch>();
        for (Declaration declaration : program.getDeclarationList()) {
            if (!(declaration instanceof ProcessDecl)) continue;
            transitions.putAll(FiacreUtil.identifyAllFracBranches((ProcessDecl)declaration));
        }
        return transitions;
    }

    public static Map<String, FracBranch> identifyAllFracBranches(ProcessDecl process) {
        HashMap<String, FracBranch> transitions = new HashMap<String, FracBranch>();
        int count = 0;
        for (Transition transition : process.getTransitionList()) {
            List<Seq> branches = FiacreUtil.computeAllFracBranches(transition.getAction(), new ArrayList<Seq>());
            int size = branches.size();
            for (int i = 0; i < size; ++i) {
                Seq branch = branches.get(i);
                int toIndex = branch.getStatementCount() - 1;
                To to = (To)branch.getStatement(toIndex);
                branch.removeStatement(toIndex);
                String id = process.getName() + "_t" + count;
                FracBranch transitionBranch = new FracBranch(id, FiacreUtil.createDescription(branch, "\\n"), transition.getFrom().getName(), to, branch);
                transitions.put(id, transitionBranch);
                ++count;
            }
        }
        List<Seq> branches = FiacreUtil.computeAllFracBranches(process.getInitAction(), new ArrayList<Seq>());
        int size = branches.size();
        for (int i = 0; i < size; ++i) {
            Seq branch = branches.get(i);
            int toIndex = branch.getStatementCount() - 1;
            To to = (To)branch.getStatement(toIndex);
            branch.removeStatement(toIndex);
            String id = process.getName() + "_t" + count;
            FracBranch transitionBranch = new FracBranch(id, FiacreUtil.createDescription(branch, "\\n"), fiacreInitialStateName, to, branch);
            transitions.put(id, transitionBranch);
            ++count;
        }
        return transitions;
    }

    public static String createDescription(Statement statement, String separator) {
        StringBuilder description = new StringBuilder();
        for (String comment : statement.getCommentList()) {
            if (!comment.startsWith("@")) continue;
            comment = comment.substring(1).trim();
            if (description.length() > 0) {
                description.append(separator);
            }
            description.append(comment);
        }
        return description.toString();
    }

    private static List<Seq> computeAllFracBranches(Statement current, List<Seq> next) {
        if (current instanceof To) {
            ArrayList<Seq> result = new ArrayList<Seq>();
            result.add(FiacreUtil.copyAndAddFirst(current, new Seq()));
            return result;
        }
        if (current instanceof Seq) {
            Seq seq = (Seq)current;
            int i = seq.getStatementCount();
            if (i <= 0) {
                return next;
            }
            List<Seq> internal = FiacreUtil.computeAllFracBranches(seq.getStatement(--i), next);
            while (i >= 0) {
                internal = FiacreUtil.computeAllFracBranches(seq.getStatement(i), internal);
                --i;
            }
            return internal;
        }
        if (current instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)current;
            ArrayList<Seq> result = new ArrayList<Seq>();
            result.addAll(FiacreUtil.computeAllFracBranches(ifStmt.getThen(), next));
            result.addAll(FiacreUtil.computeAllFracBranches(ifStmt.getElse(), next));
            return result;
        }
        if (current instanceof Select) {
            Select select = (Select)current;
            ArrayList<Seq> result = new ArrayList<Seq>();
            for (Statement statement : select.getStatementList()) {
                result.addAll(FiacreUtil.computeAllFracBranches(statement, next));
            }
            return result;
        }
        ArrayList<Seq> result = new ArrayList<Seq>();
        for (Seq one : next) {
            result.add(FiacreUtil.copyAndAddFirst(current, one));
        }
        return result;
    }

    private static Seq copyAndAddFirst(Statement first, Seq source) {
        Seq newBranch = new Seq();
        newBranch.addStatement(first);
        FiacreUtil.copyCommentList(first, newBranch);
        for (Statement statement : source.getStatementList()) {
            newBranch.addStatement(statement);
            FiacreUtil.copyCommentList(statement, newBranch);
        }
        return newBranch;
    }

    private static void copyCommentList(Statement first, Seq newBranch) {
        for (String comment : first.getCommentList()) {
            newBranch.addComment(comment);
        }
    }

    public static String[] decomposeFracDescription(String description) {
        Matcher matcher = fracPattern.matcher(description);
        if (matcher.matches()) {
            return new String[]{matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4)};
        }
        return null;
    }

    public static String[] decomposeFracTransition(String transitions) {
        Matcher matcher = fracTransitionPattern.matcher(transitions);
        ArrayList<String> result = null;
        int current = 0;
        while (matcher.find(current)) {
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.add(matcher.group(1));
            current = matcher.end();
        }
        return result.toArray(new String[result.size()]);
    }
}

