/*
 * Decompiled with CFR 0.152.
 */
package DVE.beem;

import DVE.beem.BeemInstance;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ReadBeemModelMetaInfo {
    SAXParserFactory factory = SAXParserFactory.newInstance();
    Stack<BeemInstance> instances = new Stack();
    boolean inInstance = false;
    DefaultHandler handler = new DefaultHandler(){

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("instance")) {
                BeemInstance inst = new BeemInstance();
                ReadBeemModelMetaInfo.this.instances.push(inst);
                ReadBeemModelMetaInfo.this.inInstance = true;
                inst.id = attributes.getValue("id");
            } else if (localName.equals("parameters")) {
                ReadBeemModelMetaInfo.this.inInstance &= true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String data;
            if (ReadBeemModelMetaInfo.this.instances.size() > 0 && ReadBeemModelMetaInfo.this.inInstance && (data = new String(Arrays.copyOfRange(ch, start, start + length)).trim()).length() > 0) {
                StringTokenizer toknz = new StringTokenizer(data, "=,");
                BeemInstance inst = ReadBeemModelMetaInfo.this.instances.peek();
                while (toknz.hasMoreTokens()) {
                    inst.parameters.put(toknz.nextToken(), toknz.nextToken());
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("instance")) {
                ReadBeemModelMetaInfo.this.inInstance = false;
            } else if (localName.equals("parameters")) {
                ReadBeemModelMetaInfo.this.inInstance = false;
            }
        }
    };

    List<BeemInstance> readModel(File modelFile) {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setEntityResolver(new DummyEntityResolver());
            reader.setContentHandler(this.handler);
            InputSource input = new InputSource(modelFile.toURI().toASCIIString());
            reader.parse(input);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.instances;
    }

    public static void main(String[] args) {
        ReadBeemModelMetaInfo reader = new ReadBeemModelMetaInfo();
        reader.readModel(new File("../DVECompiler/examples/BEEM/elevator/elevator.xml"));
        System.err.println(reader.instances);
    }

    public class DummyEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
            return new InputSource(new StringReader(""));
        }
    }
}

