/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.skins.JFXRadioButtonSkin$$Lambda$1;
import com.jfoenix.skins.JFXRadioButtonSkin$$Lambda$2;
import com.jfoenix.skins.JFXRadioButtonSkin$$Lambda$3;
import com.jfoenix.skins.JFXRadioButtonSkin$$Lambda$4;
import com.jfoenix.skins.JFXRadioButtonSkin$$Lambda$5;
import com.jfoenix.skins.JFXRadioButtonSkin$1$$Lambda$1;
import com.jfoenix.skins.JFXRadioButtonSkin$1$$Lambda$2;
import com.jfoenix.skins.JFXRadioButtonSkin$1$$Lambda$3;
import com.jfoenix.skins.JFXRadioButtonSkin$1$$Lambda$4;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import com.sun.javafx.scene.control.skin.RadioButtonSkin;
import javafx.animation.Interpolator;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXRadioButtonSkin
extends RadioButtonSkin {
    private final JFXRippler rippler;
    private double padding = 12.0;
    private Circle radio;
    private Circle dot;
    private final StackPane container;
    private JFXAnimationTimer timer;

    public JFXRadioButtonSkin(JFXRadioButton control) {
        super((RadioButton)control);
        double radioRadius = 8.0;
        this.radio = new Circle(8.0);
        this.radio.getStyleClass().setAll((Object[])new String[]{"radio"});
        this.radio.setStrokeWidth(2.0);
        this.radio.setFill((Paint)Color.TRANSPARENT);
        this.radio.setSmooth(true);
        this.dot = new Circle(8.0);
        this.dot.getStyleClass().setAll((Object[])new String[]{"dot"});
        this.dot.fillProperty().bind(control.selectedColorProperty());
        this.dot.setScaleX(0.0);
        this.dot.setScaleY(0.0);
        this.dot.setSmooth(true);
        this.container = new StackPane(new Node[]{this.radio, this.dot});
        this.container.getStyleClass().add((Object)"radio-container");
        this.rippler = new JFXRippler((Node)this.container, JFXRippler.RipplerMask.CIRCLE){

            @Override
            protected double computeRippleRadius() {
                double width = this.ripplerPane.getWidth();
                double width2 = width * width;
                return Math.min(Math.sqrt(width2 + width2), 300.0) * 1.1 + 5.0;
            }

            @Override
            protected void setOverLayBounds(Rectangle overlay) {
                overlay.setWidth(this.ripplerPane.getWidth());
                overlay.setHeight(this.ripplerPane.getHeight());
            }

            @Override
            protected void initControlListeners() {
                this.control.layoutBoundsProperty().addListener(JFXRadioButtonSkin$1$$Lambda$1.lambdaFactory$(this));
                if (this.getChildren().contains((Object)this.control)) {
                    this.control.boundsInParentProperty().addListener(JFXRadioButtonSkin$1$$Lambda$2.lambdaFactory$(this));
                }
                this.control.addEventHandler(MouseEvent.MOUSE_PRESSED, JFXRadioButtonSkin$1$$Lambda$3.lambdaFactory$(this));
                this.control.addEventHandler(MouseEvent.MOUSE_RELEASED, JFXRadioButtonSkin$1$$Lambda$4.lambdaFactory$(this));
            }

            @Override
            protected Node getMask() {
                double radius = this.ripplerPane.getWidth() / 2.0;
                return new Circle(radius, radius, radius);
            }

            @Override
            protected void positionControl(Node control) {
            }

            static /* synthetic */ void lambda$initControlListeners$3(1 this_, MouseEvent e) {
                this_.releaseRipple();
            }

            static /* synthetic */ void lambda$initControlListeners$2(1 this_, MouseEvent event) {
                this_.createRipple(event.getX() + this_.JFXRadioButtonSkin.this.padding, event.getY() + this_.JFXRadioButtonSkin.this.padding);
            }

            static /* synthetic */ void lambda$initControlListeners$1(1 this_, Observable observable) {
                this_.resetRippler();
            }

            static /* synthetic */ void lambda$initControlListeners$0(1 this_, Observable observable) {
                this_.resetRippler();
            }
        };
        this.updateChildren();
        control.focusedProperty().addListener(JFXRadioButtonSkin$$Lambda$1.lambdaFactory$(this, control));
        control.pressedProperty().addListener(JFXRadioButtonSkin$$Lambda$2.lambdaFactory$(this));
        this.timer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis((double)200.0), JFXKeyValue.builder().setTarget((WritableValue<?>)this.dot.scaleXProperty()).setEndValueSupplier(JFXRadioButtonSkin$$Lambda$3.lambdaFactory$(this)).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget((WritableValue<?>)this.dot.scaleYProperty()).setEndValueSupplier(JFXRadioButtonSkin$$Lambda$4.lambdaFactory$(this)).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget((WritableValue<?>)this.radio.strokeProperty()).setEndValueSupplier(JFXRadioButtonSkin$$Lambda$5.lambdaFactory$(this)).setInterpolator(Interpolator.EASE_BOTH).build()));
        this.registerChangeListener((ObservableValue)control.selectedColorProperty(), "SELECTED_COLOR");
        this.registerChangeListener((ObservableValue)control.unSelectedColorProperty(), "UNSELECTED_COLOR");
        this.registerChangeListener((ObservableValue)control.selectedProperty(), "SELECTED");
        this.updateColors();
        this.timer.applyEndValues();
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.radio != null) {
            this.removeRadio();
            this.getChildren().addAll((Object[])new Node[]{this.container, this.rippler});
        }
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("SELECTED_COLOR".equals(p)) {
            this.updateColors();
        } else if ("UNSELECTED_COLOR".equals(p)) {
            this.updateColors();
        } else if ("SELECTED".equals(p)) {
            boolean isSelected = ((RadioButton)this.getSkinnable()).isSelected();
            Color unSelectedColor = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
            Color selectedColor = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
            this.rippler.setRipplerFill((Paint)(isSelected ? selectedColor : unSelectedColor));
            if (((JFXRadioButton)this.getSkinnable()).isDisableAnimation().booleanValue()) {
                this.timer.applyEndValues();
            } else {
                this.timer.reverseAndContinue();
            }
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        RadioButton radioButton = (RadioButton)this.getSkinnable();
        double contWidth = this.snapSize(this.container.prefWidth(-1.0));
        double contHeight = this.snapSize(this.container.prefHeight(-1.0));
        double computeWidth = Math.max(radioButton.prefWidth(-1.0), radioButton.minWidth(-1.0));
        double width = this.snapSize(contWidth);
        double height = this.snapSize(contHeight);
        double labelWidth = Math.min(computeWidth - contWidth, w - width);
        double labelHeight = Math.min(radioButton.prefHeight(labelWidth), h);
        double maxHeight = Math.max(contHeight, labelHeight);
        double xOffset = JFXRadioButtonSkin.computeXOffset(w, labelWidth + contWidth, radioButton.getAlignment().getHpos()) + x;
        double yOffset = JFXRadioButtonSkin.computeYOffset(h, maxHeight, radioButton.getAlignment().getVpos()) + x;
        this.layoutLabelInArea(xOffset + contWidth + this.padding / 3.0, yOffset, labelWidth, maxHeight, radioButton.getAlignment());
        ((Text)this.getChildren().get(this.getChildren().get(0) instanceof Text ? 0 : 1)).textProperty().set(((RadioButton)this.getSkinnable()).textProperty().get());
        this.container.resize(width, height);
        this.positionInArea((Node)this.container, xOffset, yOffset, contWidth, maxHeight, 0.0, radioButton.getAlignment().getHpos(), radioButton.getAlignment().getVpos());
        double ripplerWidth = width + 2.0 * this.padding;
        double ripplerHeight = height + 2.0 * this.padding;
        this.rippler.resizeRelocate(width / 2.0 + xOffset - ripplerWidth / 2.0, height / 2.0 + xOffset - ripplerHeight / 2.0, ripplerWidth, ripplerHeight);
    }

    private void removeRadio() {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (!"radio".equals(((Node)this.getChildren().get(i)).getStyleClass().get(0))) continue;
            this.getChildren().remove(i);
        }
    }

    private void updateColors() {
        boolean isSelected = ((RadioButton)this.getSkinnable()).isSelected();
        Color unSelectedColor = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
        Color selectedColor = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
        this.rippler.setRipplerFill((Paint)(isSelected ? selectedColor : unSelectedColor));
        this.radio.setStroke((Paint)(isSelected ? selectedColor : unSelectedColor));
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.radio.minWidth(-1.0)) + this.padding / 3.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.radio.prefWidth(-1.0)) + this.padding / 3.0;
    }

    private static double computeXOffset(double width, double contentWidth, HPos hpos) {
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        return 0.0;
    }

    private static double computeYOffset(double height, double contentHeight, VPos vpos) {
        switch (vpos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        return 0.0;
    }

    public void dispose() {
        super.dispose();
        this.timer.dispose();
        this.timer = null;
    }

    static /* synthetic */ Object lambda$new$4(JFXRadioButtonSkin this_) {
        return ((RadioButton)this_.getSkinnable()).isSelected() ? ((JFXRadioButton)this_.getSkinnable()).getSelectedColor() : ((JFXRadioButton)this_.getSkinnable()).getUnSelectedColor();
    }

    static /* synthetic */ Object lambda$new$3(JFXRadioButtonSkin this_) {
        return ((RadioButton)this_.getSkinnable()).isSelected() ? 0.55 : 0.0;
    }

    static /* synthetic */ Object lambda$new$2(JFXRadioButtonSkin this_) {
        return ((RadioButton)this_.getSkinnable()).isSelected() ? 0.55 : 0.0;
    }

    static /* synthetic */ void lambda$new$1(JFXRadioButtonSkin this_, ObservableValue o, Boolean oldVal, Boolean newVal) {
        this_.rippler.setOverlayVisible(false);
    }

    static /* synthetic */ void lambda$new$0(JFXRadioButtonSkin this_, JFXRadioButton control, ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (!control.disableVisualFocusProperty().get()) {
            if (newVal.booleanValue()) {
                if (!((RadioButton)this_.getSkinnable()).isPressed()) {
                    this_.rippler.setOverlayVisible(true);
                }
            } else {
                this_.rippler.setOverlayVisible(false);
            }
        }
    }
}

